; Possible some Copy-Paste artefacts in comments due to this SRC is refactored from ES1841.0010 source.
; ====================================================================================================

; Disassembled by GlebLar@gmail.com

; STARTED FROM FFF6h - SEE BOTTOM

; Memory and I/O Map for ES1842.E015 HDC Board according to schematic ES1842 HDC (K07, List 3):
; -------------------------------------------------------------------------------------------------------------------------------------------------
; Internal i8089 Board RAM   Addresses : 0000 - 1FFF (Layout Bottom)
; Internal i8089 Board VZ2/Xebec Addrs : 4000 - 7FFF (No Datasheet founded)
; Internal i8089 Board Ports Addresses : 8000 - BFFF (Layout Bottom)
; Internal i8089 Board ROM   Addresses : C000 - FFFF (Content Bottom, Used area F000-FFFF Only: 4Kb,2xK556RT7(2Kx8 each),NO Even/Odd Bytes Separately as was 1841.0010)

; Internal i8089 Board Ports Layout (Ports accesible from internal i8089 BUS, not from ISA BUS, except Port 8000h - this is Data Port 320h on Host)
; =================================================================================================================================================
; 8000h ([gb])      Read   Chip B11 		Host Data Port (Read Data from Host [Host Port 320h]) (CHIP B11)
; (Host Port 320h)  Write  Chip A11 		Host Data Port (Write Data to Host  [Host Port 320h]) (CHIP A11)
;
; 8008h ([gb].08h)  Read   NOT USED
; 		    Write  Chip M05		CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
; 
; 8010h ([gb].10h)  Read   Chips B06, B07 	D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
; 		    Write  Chip E08 		D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
;
; 8018h ([gb].18h)  Read   NOT USED
; 		    Write  Chip B09		D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
; 
; 8020h ([gb].20h)  Read   Chips K08, D03	Start i8089 Channel 2 (Readed Data is Irrelevant, Read Acces is enough) (CHIPS K08, D03)
; 		    Write  NOT USED
; 
; 8038h ([gb].38h)  Read   NOT USED												; Both Address 38/39 are valid
; 8039h ([gb].39h)  Write  Chip B08		D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
;
; RAM Layout					; RAM Layout
; ==========					; ==========
;
; 0000h: dd					; RetAddr1 (Simulated Stack Area)
; 0004h: dd					; RetAddr2 (Simulated Stack Area)
; 0008h: dd					; RetAddr3 (Simulated Stack Area)
; 000Ch: dd					; RetAddr4 (Simulated Stack Area)
; 0010h: dd					; RetAddr5 (Simulated Stack Area) Used in Channel 2 Routine where GC = 10h at beginning
;
; 002Bh: db					; Not Used				; Inited as BC, but Not Used
;
; 0030h: db					; Controller Status Register Value
; 0031h: db					; Last Occured SenseByte0 for any drive	; Init 0
; 0032h: db					; BOOL RetryAttempt			; Init 0
; 0033h: db					; Current Sector1
; 0034h: db					; Seek Error Was Occured Flag		; Init 0
; 0035h: db					; SectorNotFoundFlag. Only Bit1 Used
; 0036h: db					; Format Command Active Flag (0/1)	; Init 0
; 0037h: db					; Long Operation Flag (0/1)		; Init 0 (Together with 36h as WORD)
; 0038h: db					; Current Sector2
; 0039h: db					; Retry Count				; Init 4 or 1 depend on 43h (Control/Retry Disable)
; 003Ah: db					; DriveCheckedAndReady BitMask		; Init 0
; 003Bh: db					; ECC Burst Len				; Init 0
; 
; 003Eh: db					; Class/OpCode from Host		; 6 Bytes Cmd Block from PC Host <======;
; 003fh: db					; Drive/Head   from Host							;
; 0040h: db					; CylHi/Sect   from Host							;
; 0041h: db					; CylLo        from Host							;
; 0042h: db					; SectNum/Interleave from Host							;
; 0043h: db					; Control, Bit 7 = RetryDisable		; 6 Bytes Cmd Block from PC Host <======;
; 0044h: db					; SenseByte0 for Drive0: ErrType/Code	; 4x Bytes Sense, See DrvIndex, 52h	; Init 0																								; Init 0
; 0045h: db					; SenseByte1 for Drive0: Drive/Head
; 0046h: db					; SenseByte2 for Drive0: CylHi/Sect
; 0047h: db					; SenseByte3 for Drive0: CylLo
; 0048h: db					; SenseByte0 for Drive1: ErrType/Code	; 4x Bytes Sense, See DrvIndex, 52h	; Init 0
; 0049h: db					; SenseByte1 for Drive1: Drive/Head
; 004Ah: db					; SenseByte2 for Drive1: CylHi/Sect
; 004Bh: db					; SenseByte3 for Drive1: CylLo
; 004Ch: db					; Port 18h Saved Value	; D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
; 004Dh: db					; Current CylHi 1
; 004Eh: db					; Current CylLo 1
; 004Fh: db					; Board Port 38 Value (Chip B08) = ~HDx/~Step/~Dir/~REDWRCUR
; 0050h: db					; Sector Value from Host
;
; 0052h: db					; 44h or 48h - Current Drive SenseBytes Pointer (4xBytes), see GetDrvSenseBytesPtr
; 0053h: db					; StoredIX Index - Word Values 73h or 75h - Stored here, but this variable not Used
; 
; 0056h: db					; Current CylLo 2
; 0057h: db					; Current CylHi 2
; 0058h: db					; TemporaryByte1
; 0059h: db					; TemporaryByte2 (Assigned but never Used !)
; 005Ah: dw					; TemporaryWord
; 005Ch: dw					; TemporaryBC
; 005Eh: dw					; Testing Cylinder For Recalibration Opn
; 0060h: db					; Error Flag / WpComp Flag / Temporary Byte / SeekCnt / Chan2 AccumHi
; 0061h: db					; Error Code / ECC Bytes Counter / Chan2 AccumLo
; 0062h: db					; TemporarySector
;
; 0064h: db					; Format Sector Layouts Array Ptr (Started from B4h)
; 0065h: db					; Last Saved Class/OpCode from Host (See 3eh) (Stored in Cmd_Read_Verify, Cmd_Write, Cmd_WriteSectBuf, Cmd_Format)
;
; 0067h: db					; ECC Correctable Flag (00 = Evaluation In Progress, 11h - Incorrectable ECC, 18h - Correctable ECC)
;
; 006Ah: db					; Chan1 - Not Used			; Chan2 - ECC Result Packet Byte 1 (3x Bytes)
; 006Bh: db					; Chan1 - Not Used			; Chan2 - ECC Result Packet Byte 2 (3x Bytes)
; 006Ch: db					; Chan1 - Not Used			; Chan2 - ECC Result Packet Byte 3 (3x Bytes)
;
; 0070h: dw					; Chan1 - Not Used			; Chan2 - Temporary Word
;
; 0073h: dw					; WORD Current Cylinder For Drive0
; 0075h: dw					; WORD Current Cylinder For Drive1
; 0077h: dw	306				; Cyl			; 132h 		; 8 Bytes HDD Parms Table for Drive 0
;        db	4 				; Head			; 4h            ; Readed from Host and placed here
;        dw	306				; RWC Cyl		; 132h
;        dw	0				; WP Cyl		; 0h
;        db	11				; EEC Burst Len		; 0bh
; 007Fh: dw	306				; Cyl			; 132h		; 8 Bytes HDD Parms Table For Drive 1
;        db	4 				; Head			; 4h            ; Readed from Host and placed here
;        dw	306				; RWC Cyl		; 132h
;        dw	0				; WP Cyl		; 0h
; 0086h: db	11				; ECC Burst Len		; 0bh		; Also Pointer to Active HDD Par Table - 1 (Reversive Transfer)
; 0087h: db	11				; ECC Burst Len		; 0bh		; ACTIVE HDD PARAMETERS TABLE <=========;
; 0088h: dw	0				; WP Cyl		; 0h		; ACTIVE HDD PARAMETERS TABLE		;
; 008Ah: dw	306				; RWC Cyl		; 132h		; ACTIVE HDD PARAMETERS TABLE		;
; 008Ch: db	4				; Head			; 4h		; ACTIVE HDD PARAMETERS TABLE		;
; 008Dh: dw	306				; Cyl			; 132h		; ACTIVE HDD PARAMETERS TABLE <=========;
;
; 0091h: db	60h				; TimeOut After AM NoLastSector	; 9 bytes Moved From ROM RelocToRamArea Start <=;
; 0092h: db	69h				; Timeout1 For Format Operation							;
; 0093h: db	0h				; Not Used									;
; 0094h: db	54h				; Timeout After AM ID Readed							;
; 0095h: db	54h				; Timeout After Last Sector AM ID Readed					;
; 0096h: db	8h				; SectNum when FmtNotWaitIndex							;
; 0097h: db	17				; Sectors Per Track (17)							;
; 0098h: dw	0060h				; Timeout2 For Format Operation	; 9 bytes Moved From ROM RelocToRamArea End <===;
;
; 00B3h: db					; B3h+00     42 Bytes Sector Layouts for Format Opn Start, Inited as 42x 0ffh <=;
; 00B4h: db	08				; B3h+01 --;									;
; 00B5h: db	00				; B3h+02   ;									;
; 00B6h: db	09				; B3h+03   ;									;
; 00B7h: db	01				; B3h+04   ;									;
; 00B8h: db	10				; B3h+05   ;									;
; 00B9h: db	02				; B3h+06   ;									;
; 00BAh: db	11				; B3h+07   ;									;
; 00BBh: db	03				; B3h+08   ;									;
; 00BCh: db	12				; B3h+09   ; 17 Sectors per Track, Interleave 2, Layout Example			;
; 00BDh: db	04				; B3h+10   ;									;
; 00BEh: db	13				; B3h+11   ;									;
; 00BFh: db	05				; B3h+12   ;									;
; 00C0h: db	14				; B3h+13   ;									;
; 00C1h: db	06				; B3h+14   ;									;
; 00C2h: db	15				; B3h+15   ;									;
; 00C3h: db	07				; B3h+16   ;									;
; 00C4h: db	16				; B3h+17 --;									;
; 00C5h: db	0FFh				; B3h+18									;
; 00C6h: db	0FFh				; B3h+19									;
; 00C7h: db	0FFh				; B3h+20									;
; 00C8h: db	0FFh				; B3h+21									;
; 00C9h: db	0FFh				; B3h+22									;
; 00CAh: db	0FFh				; B3h+23									;
; 00CBh: db	0FFh				; B3h+24									;
; 00CCh: db	0FFh				; B3h+25									;
; 00CDh: db	0FFh				; B3h+26									;
; 00CEh: db	0FFh				; B3h+27									;
; 00CFh: db	0FFh				; B3h+28									;
; 00D0h: db	0FFh				; B3h+29									;
; 00D1h: db	0FFh				; B3h+30									;
; 00D2h: db	0FFh				; B3h+31									;
; 00D3h: db	0FFh				; B3h+32									;
; 00D4h: db	0FFh				; B3h+33									;
; 00D5h: db	0FFh				; B3h+34									;
; 00D6h: db	0FFh				; B3h+35									;
; 00D7h: db	0FFh				; B3h+36   ; D7h Used in Cmd_Format as Variable Contained 0FFh			;
; 00D8h: db	0FFh				; B3h+37									;
; 00D9h: db	0FFh				; B3h+38									;
; 00DAh: db	0FFh				; B3h+39									;
; 00DBh: db	0FFh				; B3h+40									;
; 00DCh: db	0FFh				; B3h+41     42 Bytes Sector Layouts for Format Opn End,   Inited as 42x 0ffh <=;
;
; 00F6h: db	0C2h				; AM ID = C2h				Full AM field include CHS Address From VZ2/Xebec Start
; 00F7h: db					; CylHi From AM
; 00F8h: db					; CylLo From AM
; 00F9h: db					; HeadNum From AM
; 00FAh: db					; SectorNum From AM
; 00FBh: db					; AM ID Flag: 80h-Normal,81h-Remapped,82h-BAD,9Xh-LastSector
; 00FCh: db					; AM ID Zero Byte
; 00FDh: db					; ECC For AM ID Field LoWord ???
; 00FEh: dw					; ECC For AM ID Field HiWord ???
;
; 0176h: ??	???	; Unknown
;
; 0178h: ??	???	; Unknown
; 0179h: ??	???	; Unknown
;
; 017Ch: ??	???	; Unknown
; 017Dh: db					; Sector Buffer 512 Bytes Start <===============================================; SECTOR DATA HERE
;
; 0180h: ??	???	; Write Sect Buf ???
; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
; ...... ..	..				;...............................................................................;
; 037Ch: db 					; Sector Buffer 512 Bytes End <=================================================;                 

; 0381h: db	???	; Sector Data ECC (See Channel 2 Routine) ???

; ROM Content					; ROM Content
; ===========					; ===========

	org	0F000h				; Actual Program Start in ROM is F000h

;==============================================================================================================================================================
; === Channel 1 Routine start (F000), Starting every time when 8089 Pin 23 (CA) is Activated and Pin 24 (SEL)=0 (Host Write Port 322h, Controller Select Pulse)
;==============================================================================================================================================================
Chan1_Start:
        movi    gb,8000h			; GB Pointed to Board Ports
        movi    cc,8408h			; Set Transfer Block of BC Bytes from [GB].Port to [GA].Mem. ChannelControlRegister= 10 0 00 1 0 0 0 00 01 000
        movb    mc,[gb].10h			; MC = Port 10h. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movi    gc,4000h			; VZ2/Xebec Serdes Base
        movbi   [gc],20h			; VZ2/Xebec Serdes Cmd 20h (Host Exchange Start) (Same as on 1841.0004/0018)
        movbi   ga,3eh				; Destination Address (RAM) | Command block 6 bytes (BC = Already in bytes) - stored here Command from Host
        movbi   [gb].10h,0ffh			; Bit3 = 1 => Normal Opn. D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        wid     8,8				; 8-Bit Port to 8-Bit Mem
        movbi   [gb].18h,58h			; D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        xfer    				; Start DMA operation after next command
        movbi   bc,6h				; DMA counter (DMA operation start after this) | 6 Bytes of Command from Host

        movbi   gc,0h				; GC = 0

        movbi   [gb].18h,18h			; SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movbi   [gc].4ch,18h			; Store it i Port 18h Saved Value
        andbi   mc,80h				; MC = Port 10h & 80h. Mask ~DIAGNOSTIC Only
        jnz     mc,SkipInitValues1		; If No Zero =>  SkipInitValues1

	; Init values 1

        movb    [gb].8h,gc			; CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
        mov     [gc].3ah,gc			; DriveCheckedAndReady BitMask = 0
        movb    [gc].44h,gc			; SenseByte0 for Drive0 = 0
        movb    [gc].48h,gc			; SenseByte0 for Drive1 = 0

	; Copy HDD Par Table for Drive 0 from ROM to RAM

        movbi   gb,77h				; Destination Address in RAM (see next line - cc register setup GA as Source, GB as Destination)
        movi    cc,0c008h			; Set Transfer Block of BC Bytes from [GA].Mem to [GB].Mem. ChannelControlRegister= 11 0 00 0 0 0 0 00 01 000
        movi    ga,HddParTable	 		; Source Address (in ROM) => HDD Parms Table
        xfer    				; Start DMA operation after nex command
        movbi   bc,8h				; DMA counter (DMA operation start after this)

	; Copy HDD Par Table for Drive 1 from ROM to RAM

        addbi   ga,-8				; Source Address (in RAM)
        xfer    				; Start DMA operation after nex command
        movbi   bc,8h				; DMA counter (DMA operation start after this)

	; Copy 9 Bytes from ROM to RAM

        movi    ga,RelocToRamArea		; Source Address (in ROM)
        movi    gb,91h				; Destination Address in RAM for Relocated Data
        xfer    				; Start DMA operation after nex command
        movbi   bc,9				; DMA counter (DMA operation start after this)

	; Init values 2

        movi    gb,8000h        		; GB pointed to Board Ports

	; Init phase passed

SkipInitValues1:  
	mov     [gc].36h,gc			; WORD Format Command Active Flag (0/1) = 0, Long Operation Flag = 0
        lcall   [gc],ClearVars			; Initial Clear Vars
        movb    [gc].31h,gc			; Last Occured SenseByte0 for any drive = 0

	; Init Active HDD Par Table depend on Drive Number from Host

        andbi   [gc].3fh,3fh			; Clear Hi bit of Drive from Host (Indexed from 0)
        movbi   ga,77h				; HDD Par Table for Drive 0 (8 Bytes) = 77h
        jnbt    [gc].3fh,5,SelectedDrv0		; Test LoBit of DriveNum from Host (Drive 0 or 1)
        addbi   ga,8h				; HDD Par Table for Drive 1 (8 Bytes) = 7fh

SelectedDrv0:  					; GA = HDD Par Table Pointer for Host Drive Number
	movbi   ix,8h				; Set Target Index (Offset) to 8 (End Of Table)

	; Copy HDD Par Values from Table depend on Host Drive Number to Active HDD Par Table

        addi    gc,86h				; Temporary set GC to Active HDD Par Table

HddParTblLoop:  
	movb    [gc+ix],[ga]			; Copy Byte beginning from end (86h + 8 = 8eh)
        dec     ix				; Dec Target Index
        inc     ga				; Inc Source Address
        jnz     ix,HddParTblLoop		; Loop for entire HDD Parms Table
        movbi   gc,0h				; Restore GC = 0

	; Do parse Command from Host (IX = 0 Here)

        movi    mc,0ff03h			; Set Mask
        jmce    [gc].3eh,NoNeedSetDrvParm	; HostCmd == 03 (RequestSense) => NoNeedSetDrvParm | (HostCmd ^ MC.Lo) & MC.Hi) == 0 ? GoToLabel : NextCommand
        lcall   [gc],GetDrvSenseBytesPtr	; Get Current Drive SenseBytes Pointer to IX (44h or 48h), Also store IX in [gc].52h (CurDrvSenseBytesPtr)
        inc     ix
        movb    [gc+ix+],[gc].3fh		; Setup Drive Data Value for Drive/Head
        mov     [gc+ix],[gc].40h		; Setup Drive Data Value for Cyl/Sec (2 Bytes)

NoNeedSetDrvParm:
	movi    ga,HostCmdTable			; GA = HostCmdTable
        movi    mc,0f000h
        jmce    [gc].3eh,TstDrvReadyCmd		; HosCmd == 0 (TstDrvReadyCmd) | (HostCmd ^ MC.Lo) & MC.Hi) == 0 ? GoToLabel : NextCommand
        movi    mc,0f8e0h
        jmce    [gc].3eh,DiagCmdClass7		; HosCmd in Class7/Diag | (HostCmd ^ MC.Lo) & MC.Hi) == 0 ? GoToLabel : NextCommand
        movbi   mc,00e8h
        ljmcne  [gc].3eh,UnknownCmd		; HosCmd is Unknown Cmd | (HostCmd ^ MC.Lo) & MC.Hi) == 0 ? GoToLabel : NextCommand

	; "Normal" Commands here also

DiagCmdClass7:
	addbi   ga,20h				; Correct Pointer to Cmd Offset

TstDrvReadyCmd:
	movb    ix,[gc].3eh			; IX = HostCmd
        addb    ix,[gc].3eh			; IX = HostCmd * 2 (Convert to WORD)
        andbi   ix,1fh				; IX &= 1Fh (0-31 Max)
        mov     [gc],[ga+ix]			; Return Address in [gc] = Jmp Address
        mov     tp,[gc]				; Jmp to Command (Return simulate)

	; Command from Host Parse Ended

;==========================================
ClearVars:  					; Initial Clear Vars
	movb    [gc].32h,gc			; RetryAttempt = 0 (BOOL)
        movb    [gc].34h,gc			; Seek Error Was Occured Flag = 0
        movbi   [gc].39h,4h			; Retry Count = 4
        jnbt    [gc].43h,7,RetryDisable		; Test Control Byte From Host, (Bit 7 RetryDisable) and goto return if = 0
        movbi   [gc].39h,1h			; Retry Count = 1

RetryDisable:  
	mov     tp,[gc]				; Return

;==========================================
GetDrvSenseBytesPtr:  
	movbi   ix,44h				; IX = 44h
        jnbt    [gc].3fh,5,UseDrive0		; IX = (DriveNum == 1) ? 44h : 48h
        addbi   ix,4h				; IX = 48h

UseDrive0:  
	movb    [gc].52h,ix			; 44h or 48h - Current Drive SenseBytes Pointer
        mov     tp,[gc]				; Return

;==========================================
Cmd_InitDrive:		;GA=4,GB=8000h,GC=0	; Cmd 0C (Initialize Drive Characteristics)
        movbi   [gc].4ch,18h			; Set new Port 18h Saved Value by Default. SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movbi   ga,77h				; HDD Par Table for Drive 0 (8 Bytes)
        jnbt    [gc].3fh,5,Use_Drive0		; Test LoBit of DriveNum from Host (Drive 0 or 1)
        movbi   ga,7fh				; HDD Par Table for Drive 1 (8 Bytes)

Use_Drive0:  
	movbi   bc,8h				; Transfer Bytes Count
        lcall   [gc],XferDataFromHostToRam	; BC Bytes will be transferred from Host to RAM pointed by GA
        ljmp    FinishProcessToHostOK		; Done

;==========================================
WriteSectBuf:  					; Sector data (BC Bytes) will be transferred from Host to RAM Location
	movi    ga,180h				; Sector Buffer + 3
        movi    bc,512				; Sector Size
        jzb     [gc].37h,XferDataFromHostToRam	; If No Long Operation Flag => XferDataFromHostToRam
        addbi   ga,-4				; GA -= 4
        addbi   bc,4h				; BC += 4

XferDataFromHostToRam:  			; BC Bytes will be transferred from Host to RAM pointed by GA  
        movi    cc,8408h			; Set Transfer Block of BC Bytes from [GB].Port to [GA].Mem. ChannelControlRegister= 10 0 00 1 0 0 0 00 01 000
        movi    ix,4000h			; IX = VZ2/Xebec Serdes Base
        movbi   [gc+ix],20h			; VZ2/Xebec Serdes Cmd 20h (Host Exchange Start) (Same as on 1841.0004/0018)
        xfer    				; Start DMA Transfer Port(GB)->Mem(GA) after next command 
        wid     8,8
        mov     tp,[gc]				; Return

;==========================================
ReadSectBuf_GA_180:  				; Sector data (BC Bytes) will be transferred from RAM Location 180h to Host
	movi    ga,180h				; Sector Buffer + 3
        movi    bc,512				; Sector Size
        jmp     XferDataFromRamToHost		; Go To XferDataFromRamToHost

;==========================================
ReadSectBuf_GA_17D:  				; Sector data (BC Bytes) will be transferred from RAM Location 17D to Host
	movi    ga,17dh				; Sector Buffer

ReadSectBuf:  					; BC Bytes from RAM pointed by GA will be transferred to Host
	movi    bc,512				; Sector Size
        jzb     [gc].37h,XferDataFromRamToHost	; if No Long Operation Flag => XferDataFromRamToHost
        addbi   ga,-4				; GA -= 4
        addbi   bc,4h				; BC += 4
XferDataFromRamToHost:  			; BC Bytes from RAM pointed by GA will be transferred to Host
	movbi   mc,20h				; MC = 20h. INPUT for Board Port 18h (Chip B09). D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        orb     mc,[gc].4ch			; Add other bits from Port 18h Saved Value (Cur Drive, ...). D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movb    [gb].18h,mc			; Set INPUT Bit Only. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movi    ix,4000h			; IX = VZ2/Xebec Serdes Base
        movbi   [gc+ix],20h			; VZ2/Xebec Serdes Cmd 20h (Host Exchange Start) (Same as on 1841.0004/0018)
        movi    cc,4008h			; Set Transfer Block of BC Bytes from [GA].Mem to [GB].Port. ChannelControlRegister= 01 0 00 0 0 0 0 00 01 000
        xfer    				; Start DMA Transfer Mem(GA)->Port(GB) after next command 
        wid     8,8				; From 8-Bit RAM to 8-Bit Port
        movb    [gb].18h,[gc].4ch		; Set Saved Value. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        mov     tp,[gc]				; Return

;==========================================
Cmd_RequestSense:	;GA=4,GB=8000h,GC=0	; Cmd 03 (Request Sense Status)
        movbi   [gc].4ch,18h			; Set new Port 18h Saved Value by Default. SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        lcall   [gc],GetDrvSenseBytesPtr	; Get Current Drive SenseBytes Pointer to IX (44h or 48h), Also store IX in [gc].52h (CurDrvSenseBytesPtr)
        movb    ga,[gc].52h			; GA = 44h or 48h - Current Drive SenseBytes Pointer
        movbi   bc,4h				; Transfer Counter
        lcall   [gc],XferDataFromRamToHost	; BC Bytes from RAM pointed by GA will be transferred to Host
        movb    [gc].31h,[gc+ix]		; Store Last Occured SenseByte0 for any drive
        ljmp    FinishProcessToHostOK		; Done

;==========================================
Cmd_Unknown:		;GA=4,GB=8000h,GC=0	; Cmds 02 (Reserved), 09 (Reserved), E1 (Reserved), E2 (Reserved)
        ljmp    UnknownCmd			; Unknown Command Received from Host

;==========================================
Cmd_Undoc1:		;GA=4,GB=8000h,GC=0	; Cmd E7 (Undocumented1, ES-1842 Specific) - Write Output Drive Signals = Port 38h (Chip B08) on Board
        movb    mc,[gc].40h			; CylHi/Sect from Host (May Be Other Parameter for this Undoc Command)
        andbi   mc,0b3h				; MC &= B3h
        jnbt    [gc].40h,3,UndocSkipOr		; [gc].40h != 0 => UndocSkipOr
        orbi    mc,2h				; MC |= 02h

UndocSkipOr:  
	movb    [gb].38h,mc			; Set New Board Port 38 Value from MC. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
        movb    mc,[gc].41h			; CylLo from Host (May Be Other Parameter for this Undoc Command)
        andbi   mc,1fh				; MC &= 1Fh
        movb    [gc].4ch,mc			; Port 18h Value in RAM for future use. (May Be Other Values for this Undoc Command). D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movbi   bc,0h				; No Error
        ljmp    FinishProcessToHost2		; Done

;==========================================
Cmd_Undoc2:		;GA=4,GB=8000h,GC=0	; Cmd E8 (Undocumented2, ES-1842 Specific) - Read Input Drive Signals = Port 10h (Chips B06, B07) on Board
        movb    mc,[gb].10h			; MC = Port 10h Value. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        andbi   mc,0fh				; MC &= 0Fh. Mask D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY (CHIPS B06,B07)
        movb    [gc].45h,mc			; Store MC in SenseByte1 for Drive0: Drive/Head => Used as Diagnostic (UNDOCUMENTED)
        ljmp    FinishProcessToHostOK		; Done

;==========================================
UnknownCmd:  
	movbi   bc,20h				; INVALID COMMAND ERROR !!! The controller has received an invalid command from the system unit.

;==========================================
ErrorDetected:  
	movb    [gc].61h,bc			; BC = Error Code here
        movbi   [gc].60h,2h			; Set Error Flag
        mov     bc,[gc].60h			; Set BC as WORD(Error/OK Flag = Error, ErrorCode)
        jmp     FinishProcessToHost		; Done

;==========================================
FinishProcessToHostOK: 
	movbi   bc,0h				; NO ERROR DETECTED !!! - Set BS as Error/OK Flag = OK

FinishProcessToHost:				; BC = 2 (Error) or 0 (NoError) Here
	movi    gb,8000h			; GB Pointed to Board Ports
        movbi   [gb].18h,18h			; SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movbi   [gc].4ch,10h			; Set Port 18h Saved Value By Default. NO SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movb    [gc].41h,gc			; CylLo from Host = 0

FinishProcessToHost2:  				; BC = 2 (Error) or 0 (NoError) Here
	movb    [gc].30h,bc			; Controller Status Register Value = BC (Error/OK Flag)
        jnbt    [gc].3fh,5,NoDrvNum1		; Test LoBit of DriveNum from Host (Drive 0 or 1)
        setb    [gc].30h,5			; Set Drive bit in Controller Status Register Value

NoDrvNum1:  
	or      [gc].30h,bc			; Repeatly set Error/OK Flag in Controller Status Register Value
        lcall   [gc],GetDrvSenseBytesPtr	; Get Current Drive SenseBytes Pointer to IX (44h or 48h), Also store IX in [gc].52h (CurDrvSenseBytesPtr)
        movb    [gc+ix],[gc].31h		; [gc+ix] = Last Occured SenseByte0 for any drive
        movbi   mc,20h				; MC = VZ2/Xebec Serdes Cmd 20h (Host Echange Start) (Same as on 1841.0004/0018)
        movi    ix,4000h			; IX = VZ2/Xebec Serdes Base
        movb    [gc+ix],mc			; VZ2/Xebec Serdes Cmd 20h (Host Echange Start) (Same as on 1841.0004/0018)
	movb    mc,[gc].4ch			; MC = Port 18h Saved Value. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        orbi    mc,0e8h				; MC |= E8h. SELECT/NO DIAG/INPUT/CMD/SETINTR. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movb    [gb].18h,mc			; Set value above D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movb    [gb],[gc].30h			; Host Data Port (Write Data to Host  [Host Port 320h]) (CHIP A11) = Its Value from corresponded Memory Variable
        movb    [gb].18h,[gc].4ch		; Set Saved Value. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movbi   [gb].10h,0ffh			; Bit3 = 1 => Normal Opn. D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        hlt     				; Process ended, stop and waiting next event for wakeup

;==========================================
ChkDiskAddrValid:  				; Check if Addres on Disk received from Host is Valid
	movbi   [gc].31h,80h			; Last Occured SenseByte0 for any drive = 80h (AddressValid)
        mov     mc,[gc].3fh			; MC = WORD(Drive/Head from Host, CylHi/Sect fromHost) 
        andi    mc,3f1fh			; Mask in MC Only Sector and Head from Host (MC &= 3F1Fh)
        mov     [gc].4fh,mc			; Store WORD Head in Board Port 39 Value (Chip H14), and Sector in [gc].50h.
        not     mc				; Logical NOT of WORD Head in Board Port 39 Value (Chip H14), and Sector in [gc].50h.
        addb    mc,[gc].8ch			; Add Byte Max Head Num for Current HDD
        andbi   mc,40h				; Mask bit 6 of Result
        jnz     mc,DiskAddrNotValid		; If bit 6 of Result not Zero - DiskAddrNotValid (Checked in Calc for sure :-))
        notb    mc,[gc].50h			; MC = Signed Extended Sector Value from Host
        addb    mc,[gc].97h			; MC += Sectors Per Track (17)
        andbi   mc,80h				; Mask Hi Bit
        jnz     mc,DiskAddrNotValid		; Sector from Host > SPT => Addres on Disk not valid
        jnbt    [gc].40h,6,SkipCylHiBit6	; MC = 0 Here. CylHi/Sect from Host Bit6 == 0 ? Skip set Bit0 in MC 
        orbi    mc,1h				; Set Bit0 in MC

SkipCylHiBit6:  
	jnbt    [gc].40h,7,SkipCylHiBit7	; CylHi/Sect from Host Bit7 == 0 ? Skip set Bit1 in MC
        orbi    mc,2h				; Set Bit1 in MC

SkipCylHiBit7: 
	movb    [gc].4dh,mc			; Store Current CylHi 1. Byte MC = CylHi Here
        movb    [gc].57h,mc			; Store Current CylHi 2. Byte MC = CylHi Here
        movb    mc,[gc].41h			; MC = CylLo from Host
        movb    [gc].4eh,mc			; Current CylLo 1 = CylLo from Host
        movb    [gc].56h,mc			; Current CylLo 2 = CylLo from Host
        not     mc,[gc].56h			; MC = NOT WORD Current CylLo/Hi 2
        add     mc,[gc].8dh			; MC += (WORD) Number of Cylinders for Current Drive
        andi    mc,8000h			; Mask WORD Hi Bit
        jnz     mc,DiskAddrNotValid		; WORD Current CylLo/Hi 2 > (WORD) Number of Cylinders for Current Drive => Addres on Disk not valid
        mov     tp,[gc]				; Return

DiskAddrNotValid:  				; Addres on Disk not valid
	movbi   bc,21h				; ILLEGAL DISK ADDRESS ERROR !!! The controller detected an address that is beyond the maximum range.
        ljmp    ErrorDetected			; Done with Error

;==========================================
FmtCmdChkParmSetLayout:  
        notb    mc,[gc].42h			; MC = NOT Interleave from Host
        addb    mc,[gc].97h			; MC += Sectors Per Track (17)
        andbi   mc,80h				; Mask Hi Bit
        jz      mc,InterleaveOK			; If interleave < Sectors Per Track (17) => InterleaveOK, Continue
	ljmp    UnknownCmd			; Error in Parameters

InterleaveOK:  
	jnzb    [gc].42h,InterleaveNonZero	; If Interleave from Host != 0 => OK, InterleaveNonZero
        incb    [gc].42h			; Else Interleave from Host = 1

InterleaveNonZero:  
	movi    ga,0b3h				; 42 Bytes Sector Layouts for Format Operation
        movbi   ix,43				; IX = 42 + 1 (-1 on Loop Started) [Max Possible SPT]

RepeatInitFmtTbl:  
	dec     ix				; Decrement Index
        movbi   [ga+ix],0ffh			; Init table entry as FF
        jnz     ix,RepeatInitFmtTbl		; Repeat
        movbi   bc,0h				; Sector Layout Byte = 0
        jmp     NextSetInTbl			; IX = 0 Here

NextRound:  
	addb    ix,[gc].42h			; IX += Interleave from Host

NextSetInTbl:
	movb    [gc].58h,ix			; TemporaryByte1 = IX
        notb    [gc].58h			; NOT TemporaryByte1
        movb    mc,[gc].97h			; MC = Sectors Per Track (17)
        addb    [gc].58h,mc			; NOT TemporaryByte1 += MC
        jnbt    [gc].58h,7,NoOverrun		; If HiBit of TemporaryByte1 != 1 => NoOverrun
        notb    ix,[gc].58h			; IX = NOT TemporaryByte1

NoOverrun:  
	jnbt    [ga+ix],7,GoNextSetInTbl	; Index OK ?
        movb    [ga+ix],bc			; Store Sector Layout Byte. ForItlv2: [2]=0,[4]=1,[6]=2, [8]=3, [10]=4,[12]=5, [14]=6, [16]=7,
        inc     bc				; Increment Sector Layout Byte.       [1]=8,[3]=9,[5]=10,[7]=11,[9]=12,[11]=13,[13]=14,[15]=15,[17]=16)
        notb    mc,[ga+ix]			; MC = NOT Index
        addb    mc,[gc].97h			; MC += Sectors Per Track (17)
        jnz     mc,NextRound			; If not Done - next Round
        mov     tp,[gc]				; Return

GoNextSetInTbl:  
	inc     ix				; IX++
        jmp     NextSetInTbl			; Next Sector in Table

;==========================================
CheckAndSet_WP_RWC:  				; Check And Set Write Precompensation and Reruce Write Current Logic
	not     mc,[gc].56h			; MC = NOT WORD Current CylHi/Lo 2. WORD([gc].56h, [gc].57h)
        add     mc,[gc].8ah			; MC += WORD RWC Cyl for Current Drive Num
        andi    mc,8000h			; Mask Hi Bit
        movb    [gc].60h,gc			; Clear WpComp Flag
        jz      mc,NoCylRWC			; If Current Cylinder 2 < RWC Cylinder for this Drive => NoCylRWC
        setb    [gc].4fh,7			; Activate ~REDWRCUR Signal (Inverted) in Memory Copy. Board Port 39 bit 7 (Chip H14)

NoCylRWC:  
	jz      [gc].88h,NoCylWP		; If WORD WP Cyl for Current Drive Num == 0 => NoCylWP
	not     mc,[gc].56h			; MC = NOT WORD Current CylHi/Lo 2. WORD([gc].56h, [gc].57h)
        add     mc,[gc].88h			; MC += WORD WP Cyl for Current Drive Num
        andi    mc,8000h			; Mask Hi Bit
        jz      mc,NoCylWP			; If Current Cylinder 2 < WP Cylinder for this Drive => NoCylWP
        movbi   [gc].60h,1h			; Set WpComp Flag

NoCylWP:  
	movi    ix,4001h			; IX = VZ2/Xebec Serdes Base + 1
        movb    [gc+ix],[gc].60h		; Set Write Precompensation Mode (Same as on 1841.0004/0018)
        mov     tp,[gc]				; Return

;==========================================
Cmd_DrvRecalibrate:	;GA=4,GB=8000h,GC=0	; Cmd 01 (Recalibrate)
        mov     [gc].5ah,gc			; TemporaryWord = 0
        lcall   [gc].4h,CheckDrvReady		; Check Drive Ready
        lcall   [gc].8h,DrvRecalibrate		; Recalibrate Drive (Decremental Seek until Track0 Reached)
        ljmp    FinishProcessToHostOK		; Done

;==========================================
CheckDrvReady:  				; Check Drive Ready
	movb    [gc].4fh,gc			; Clear Board Port 39 Value (Chip H14) InMem = ~HDx/~Step/~Dir/~REDWRC

ChkDrvReady:  					; Check Drive Ready
	movbi   mc,1h				; Drive0
        jnbt    [gc].3fh,5,SkipDrv1		; Test LoBit of DriveNum from Host (Drive 0 or 1)
        movbi   mc,2h				; Drive1

SkipDrv1:  					; MC = Drive Here
	orb     [gc].4ch,mc			; Set new Port 18h Value => Drive1 (Not Suported by this board)
        movb    [gb].18h,[gc].4ch		; Set Value Above. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        lcall   [gc],CheckAndSet_WP_RWC		; Check And Set Write Precompensation and Reruce Write Current Logic
        movb    [gb].38h,[gc].4fh		; Set New Board Port 38 Value from it RAM Copy. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
        jnbt    [gb].10h,3,DrvNotReady		; Test Bit3 and goto DrvNotReady if = 0 (NOT READY). D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movbi   bc,3h				; WRITE FAULT ERROR !!! The controller detected a write fault from the drive during the last operation.
        ljbt    [gb].10h,1,ErrorDetected	; Test Bit1 and goto ErrorDetected if = 1 (WRITE FAULT OCCURED). D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movb    mc,[gc].4ch			; MC = Port 18h Value. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        andb    mc,[gc].3ah			; MC &= DriveCheckedAndReady BitMask. ThisBitMask Inited as 0
        jz      mc,FirstTimePass		; First Time Already Zero - No Drive was Tested and Ready
        jnzb    [gc].3eh,CalledFromNonTstReady	; Called From non TestDriveReady Command from Host. [gc].3eh = HostCmd
        movbi   bc,8h				; DRIVE STILL SEEKING ERROR !!! The drive is still seeking. This status is reported by the Test Drive Ready 
						; command for an overlap seek condition when the drive has not completed the seek. 
						; No time-out is measured by the controller for the seek to complete.
        ljmp    ErrorDetected			; Done with Error

CalledFromNonTstReady:  
	notb    mc,[gc].4ch			; MC = NOT Port 18h Saved Value. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        andb    [gc].3ah,mc			; Clear DriveCheckedAndReady Bitmask for this Drive
        lcall   [gc],WaitReadyAndSeekComplete	; Wait Ready And Seek Complete. BC = 3 Here. If Timeout => ErrorDetected
        mov     tp,[gc].4h			; Return

FirstTimePass:  
	jnbt    [gb].10h,2,DrvNotReady		; Test Bit2 and goto DrvNotReady if = 0 (NO SEEK COMPLETE). D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        mov     tp,[gc].4h			; Return

DrvNotReady:
	movbi   bc,4h				; ILLEGAL DISK ADDRESS ERROR !!! The controller detected an address that is beyond the maximum range.
        ljmp    ErrorDetected			; Done with Error

;==========================================
WaitReadyAndSeekComplete:  			; Wait Ready And Seek Complete. If Timeout => ErrorDetected
	mov     [gc].5ch,bc			; Save BC. TemporaryBC = BC. WORD([gc].5ch, [gc].5dh) = BC
        movbi   bc,0h				; BC = 0
        movbi   ix,3h				; IX = 3
	movi    mc,0c0ch			; MC = Mask

WaitReadyAndSeekCompl:  
        jmce    [gb].10h,DrvReadySeekComplete	; Drive Ready and Seek Complete ? => DrvReadySeekComplete. ((Board Port 10h (Chips B06, B07) ^ 0Ch ) & 0Ch) == 0. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        dec     bc				; Decrement TimeOut Lo (Dec from Zero = MaxValue)
        jnz     bc,WaitReadyAndSeekCompl	; Continue if Not Timeout
        dec     ix				; Decrement TimeOut Hi
        jnz     ix,WaitReadyAndSeekCompl	; Continue if Not Timeout
        movbi   bc,2h				; DRIVE NO SEEK COMPLETE ERROR !!! The controller did not get a seek-complete signal from the drive after a seek operation (for all non-buffered step seeks).
        ljmp    ErrorDetected			; Done with Error

DrvReadySeekComplete:  				; Drive Ready and Seek Complete
	mov     bc,[gc].5ch			; Restore BC. BC = TemporaryBC. BC = WORD([gc].5ch, [gc].5dh)
        mov     ix,[gc].5ah			; IX = TemporaryWord. IX = WORD([gc].5ah, [gc].5bh)
        mov     tp,[gc]				; Return

;==========================================
DrvRecalibrate:  				; Recalibrate Drive (Decremental Seek until Track0 Reached)
	mov     mc,[gc].8dh			; MC = WORD Number of Cylinders for Current Drive
        clr     [gc].4fh,5			; Deactivate ~DIR Signal. Board Port 39 Value (Chip H14) = Clear Inverted ~DIR
        addi    mc,145h				; One of Testing Cylinders
        mov     [gc].5eh,mc			; Testing Cylinder For Recalibration Opn = MC. WORD([gc].5eh, [gc].5fh) = MC

RepeatSeekOpn:  
	jbt     [gb].10h,0,TrackZeroReached	; If Track0 Reached => TrackZeroReached. Test Bit0 and => TrackZeroReached if=1. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movbi   [gc].5ah,1h			; TemporaryWord = 1
        lcall   [gc].4h,DoDifficultSeekOpn	; Perform Difficult Seek Operation
        dec     [gc].5eh			; Decrement Testing Cylinder For Recalibration Opn
        jnz     [gc].5eh,RepeatSeekOpn		; (Testing Cylinder For Recalibration Opn != 0) ? => RepeatSeekOpn
        movbi   bc,6h				; TRACK 0 NOT REACH ERROR !!! After stepping the maximum number of cylinders, the controller did not receive the track 00 signal from the drive.
        ljmp    ErrorDetected			; Done with Error

TrackZeroReached:  
	lcall   [gc],GetCurCylIndexDependOnDrv	; IX = 73h or 75h -> Current Cylinder Index Depend On Drive
        mov     [gc+ix],gc			; Clear Current Cylinder Depend On Drive
        mov     tp,[gc].8h			; Return

;==========================================
GetCurCylIndexDependOnDrv:  			; IX = 73h or 75h -> Current Cylinder Index Depend On Drive
	movbi   ix,73h				; IX = 73h
        jbt     [gc].4ch,0,PerformDrive0	; Port 18h Saved Value. If (Cur Drive == 0) Skip Increment. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        addbi   ix,2h				; IX = 75h

PerformDrive0:  
	movb    [gc].53h,ix			; Store IX in StoredIX ([gc].53h) - Not Used
        mov     tp,[gc]				; Return

;==========================================
Read_AM_ID_Common:  				; Read AM ID in Common Case
	jzb     [gc].36h,NoFmtOpnActive		; Format Command Active Flag (0/1) Active ?
        lcall   [gc],GetCurCylIndexDependOnDrv	; IX = 73h or 75h -> Current Cylinder Index Depend On Drive
        not     mc,[gc+ix]			; MC = NOT Current Cylinder Depend On Drive
        jmp     ProcessingCyl			; Do processing Cylinder

NoFmtOpnActive:  
	lcall   [gc].4h,Read_AM_ID_NoFmtOpn	; Read AM ID For Non-Format Operation
        jmp     AmWasReadedOK			; Function above Returned OK
RetError:  					; Function above Returned with Error
	addbi   [gc].8h,3h			; Prepare to Return Error
        mov     tp,[gc].8h			; Return Error

AmWasReadedOK:  
	movb    [gc].59h,[gc].0f7h		; CylHi From AM
        movb    [gc].58h,[gc].0f8h		; CylLo From AM
        not     mc,[gc].58h			; MC = WORD NOT TemporaryByte1 (CylLo From AM)

ProcessingCyl: 					; MC = NOT Current Cylinder Depend On Drive
	lcall   [gc],GetCurCylIndexDependOnDrv	; IX = 73h or 75h -> Current Cylinder Index Depend On Drive
        mov     [gc+ix],[gc].56h		; WORD Current Cylinder Depend On Drive = Current CylHi/Lo 2. WORD([gc].56h, [gc].57h)
        add     mc,[gc].56h			; MC += Current CylLo 2
        mov     [gc].5ah,mc			; TemporaryWord = MC. WORD([gc].5ah, [gc].5bh) = MC	
        not     [gc].5ah			; NOT TemporaryWord
        jnz     [gc].5ah,CylinderNotMatch	; TemporaryWord != 0 => CylinderNotMatch
        mov     tp,[gc].8h			; Return

CylinderNotMatch:
        clr     [gc].4fh,5			; Deactivate ~DIR Signal. Board Port 39 Value (Chip H14) = Clear Inverted ~DIR
        jnbt    [gc].5bh,7,Do_Seek		; (HiByte TemporaryWord Bit7 == 0) ? => Do_Seek

        inc     mc				; MC ++
        mov     [gc].5ah,mc			; TemporaryWord = MC. WORD([gc].5ah, [gc].5bh) = MC	
        setb    [gc].4fh,5			; Activate ~DIR Signal. Board Port 39 Value (Chip H14) = Set Inverted ~DIR

Do_Seek:  
	lcall   [gc].4h,DoDifficultSeekOpn	; Perform Difficult Seek Operation
	jzb     [gc].36h,NoFrmtOpnActive	; Format Command Active Flag (0/1) Active ?
        mov     tp,[gc].8h			; Return if Format Operation Active

NoFrmtOpnActive:  
	movb    [gc].38h,[gc].97h		; Current Sector2 = Sectors Per Track (17)

DoReadAmIdNextSect:  
        lcall   [gc],ReadAmID_12Bytes_TOut1	; Read Address Mark ID (AM ID, 12 Bytes) to RAM at Address 0E2h With TimeOut1
        jmp     AM_Read1_OK			; Function above Returned OK        
AM_Read1_BAD:  			  		; Function above Returned with Error
	decb    [gc].38h			; Dec Current Sector2
        jzb     [gc].38h,RetError		; All Sectors2 ? => RetError
        jmp     DoReadAmIdNextSect		; Do Read AM ID For Next Sector

AM_Read1_OK:  
	movbi   bc,10h				; ID READ ERROR, ID ECC ERROR !!! The controller detected an ECC error in the target ID field on the disk.
        jnbt    [gb].10h,4,AM_Read1_BAD		; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movb    ix,[gc].91h			; TimeOut After AM NoLastSector
        jnbt    [gc].0fbh,4,NoLastSect		; AM ID Flag: 80h-Normal,81h-Remapped,82h-BAD,9Xh-LastSector
        lcall   [gc],DoWaitIndex		; Do Wait Index Signal from Drive
        jmp     AfterWaitIndex			; Goto AfterWaitIndex

NoLastSect:  
	dec     ix				; Decrement TimeOut After AM NoLastSector
        jnz     ix,NoLastSect			; Loop Until Not Zero

AfterWaitIndex:  
	lcall   [gc],ReadAmID_12Bytes_TOut2	; Read Address Mark ID (AM ID, 12 Bytes) to RAM at Address 0E2h With TimeOut1
        jmp     AM_Read2_OK			; Function above Returned OK
        jmp     AM_Read1_BAD			; Function above Returned with Error

AM_Read2_OK:  
	movbi   bc,10h				; ID READ ERROR, ID ECC ERROR !!! The controller detected an ECC error in the target ID field on the disk.
        jnbt    [gb].10h,4,AM_Read1_BAD		; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        mov     tp,[gc].8h			; Return

;==========================================
Read_AM_ID_NoFmtOpn:  
        movb    mc,[gc].97h			; Sectors Per Track (17)

ProcNextSect:  
	lcall   [gc],ReadAmID_12Bytes_TOut1	; Read Address Mark ID (AM ID, 12 Bytes) to RAM at Address 0E2h ??? With TimeOut1
        jmp     SectIdReadedOK			; Function above Returned OK        
RetrnError:  					; Function above Returned with Error
	dec     mc				; Decrement Sector
        jnz     mc,ProcNextSect			; Not ALL Sectors ? => Loop
        addbi   [gc].4h,3h			; Prepare to Return Error
        mov     tp,[gc].4h			; Return Error

SectIdReadedOK:  
	movbi   bc,10h				; ID READ ERROR, ID ECC ERROR !!! The controller detected an ECC error in the target ID field on the disk.
        jnbt    [gb].10h,4,RetrnError		; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movbi   ga,3eh				; GA = 3Eh
        addb    ga,[gc].0f6h			; GA += 0C2H. Address Mark ID (=C2h)
        jnz     ga,RetrnError			; In normal Case = 0. Otherwise - Error
        mov     tp,[gc].4h			; Return

;==========================================
DoWaitIndex:  					; Do Wait Index Signal from Drive
	movi    bc,4ffh				; TimeOut Value for WaitIndex

IndexWaitLoop:  
	dec     bc				; Decrement Timeout
        jbt     [gb].10h,6,IndexFound		; If Index found => IndexFound. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        jnz     bc,IndexWaitLoop		; If Not Timeout => Loop
        movbi   bc,1h				; INDEX NOT DETECTED ERROR !!! The controller did not detect an index signal from the drive.
        ljmp    ErrorDetected			; Done with Error

IndexFound:  
	mov     tp,[gc]				; Return

;==========================================
ReadAmID_12Bytes_TOut1:  
	movi    bc,6cffh			; Timeout for i8089 External signal terminated transfer
        jmp     AM_Det_Err01			; Goto AM_Det_Err01

ReadAmID_12Bytes_TOut2:  
	movi    bc,2ffh				; Timeout for i8089 External signal terminated transfer

AM_Det_Err01:  
	movi    ix,4000h			; VZ2/Xebec Serdes Base
        movbi   [gc+ix],10h			; VZ2/Xebec Serdes Cmd 10h (Set Transfer Direction Serdes => Host) (Same as on 1841.0004/0018)
        movb    [gb].8h,gc			; CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
        movi    ga,0f6h                         ; Offset of Address Mark ID = Address to place Full AM field include CHS Address
        movi    cc,0448h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs4, BC/0 !! from [GB].Port to [GA].Port. ChannelControlRegister= 00 0 00 1 0 0 0 10 01 000
        wid     16,16				; From 16-Bit Port to 16-Bit Port
        movbi   [gb].10h,76h			; Bit3 = 0 => VZ2/Xebec Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movi    gb,8f4h	; Real Addr=0f5h	; A0 = A11 here (See H13 Mux on Schematic). Real Address is 0000 0000 1111 0101 = 0F5
						; MUX Ctrl = Port [gb].10h, Bit03. If 1 => Normal Opn, If 0 => VZ2/Xebec Opn 
						; At the same time, the RAM write enable signal is switched by the same multiplexer to the VZ2/Xebec read signal.
						; As a result, the following DMA transfer cycle writes information from VZ2/Xebec to RAM.
						; I think that this is resolve three problems simultaneously.
						; We must have another address than the source address (if source address is equal to destination 
						; address, i8089 may be do not anything), this addres must be under control, not enough set A0 to 
						; groung (A11 under our control) and this must be A0 to avoid increment addressing during transfer.
        xfer    				; Start transfer. Pointers not incremented - DMA using here to wait Ext Signal during BC Timeout only, transferred data are irrelevant !!!
        movbi   [gc+ix],80h			; VZ2/Xebec Serdes Cmd 80h (Start AM Detection, if success - xfer full AM field include CHS Address to i8089 RAM) (Same as on 1841.0004/0018)
        ljmp    AM_Det_Err00			; Off +0 => BC Expired (TimeOut). This Command id 4 bytes length
        xfer    				; Off +4 => Previous Transfer OK, do Next Transfer. Really transfer bytes with pointers incremented.
        movi    cc,0c620h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs0, NoBC, LOCK !! from [GB].Mem to [GA].Mem. ChannelControlRegister= 11 0 00 1 1 0 0 01 00 000
        ljmp    AM_Det_No_Err			; Gooto AM_Det_No_Err

AM_Det_Err00:  
	movbi   bc,12h				; AM NOT FOUND ERROR !!! The controller did not detect the target address mark (AM) on the disk.
        addbi   [gc],3h				; Prepare Return Error

AM_Det_No_Err:  
	movb    [gc+ix],gc			; VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018)
        movi    gb,8000h			; Set back GB = 8000h
        mov     tp,[gc]				; Return OK

;==========================================
NextSector:  					; Goto Next Sector With correction Head and Possible Cylinder, if needed
	lcall   [gc].4h,IncAndValidSenseSector	; Increment And Validate Sense Sector Value
        jz      mc,NextHead			; MC == 0 If IncAndValidSenseSector fun was Corrected Sector Number (New Sector Exceed SPT, Head/Cyl Correction Needed)
        mov     tp,[gc].8h			; Return OK

NextHead:  					; Goto Next Head With Correction Cylinder, if needed
	lcall   [gc].4h,IncValidSenseHeadAndCyl	; Increment and Validate Sense Head And Cylinder

NextCyl:					; Goto Next Cylinder (Seek to Next Cylinder)
	movb    ix,[gc].52h			; 44h or 48h - Current Drive SenseBytes Pointer
        inc     ix				; Indexed to SenseByte1
        movb    mc,[gc+ix]			; MC = SenseByte1 : Drive/Head
        andbi   mc,1fh				; Mask Head Only
        jnz     mc,NoHead0			; No Head0
        movb    [gc].4fh,gc			; Clear Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR
        not     mc,[gc].56h			; MC = Current CylLo 2
        add     mc,[gc].8dh			; MC += (WORD)Number of Cylinders for Current Drive
        jnz     mc,SeekNextCyl			; No Overrun => Seek to Next Cylinder
        movbi   bc,21h				; ILLEGAL DISK ADDRESS ERROR !!! The controller detected an address that is beyond the maximum range.
        addbi   [gc].8h,3h			; Prepare to Return Error
        mov     tp,[gc].8h			; Return Error

SeekNextCyl:  
	inc     [gc].56h			; Increment WORD Current CylHi/Lo 2
        mov     mc,[gc].56h			; MC = This Incremented Value. WORD([gc].56h, [gc].57h) = Current CylHi 2, Current CylLo 2
        lcall   [gc],GetCurCylIndexDependOnDrv	; IX = 73h or 75h -> Current Cylinder Index Depend On Drive
        mov     [gc+ix],mc			; WORD Current Cylinder Depend On Drive = MC
        movb    [gc].4eh,mc			; Current CylLo 1 = BYTE MC
        movb    [gc].4dh,[gc].57h		; Current CylHi 1 = Current CylHi 2
        lcall   [gc],CheckAndSet_WP_RWC		; Check And Set Write Precompensation and Reruce Write Current Logic
        setb    [gc].4fh,5			; Activate ~DIR Signal. Board Port 39 Value (Chip H14) = Set Inverted ~DIR
        movi    [gc].5ah,1h			; TemporaryWord = MC
        ljmp    Do_Seek				; Do Seek

NoHead0:  
	andbi   [gc].4fh,0e0h			; Clear ALL HDx Bits and ~STEP Bit. Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR (&= E0h)
        orb     [gc].4fh,mc			; Set Real HDx Bits Values. Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR
        movb    [gb].38h,[gc].4fh		; Set New Board Port 38 Value from it RAM Copy. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
        mov     tp,[gc].8h			; Return OK

;==========================================
IncAndValidSenseSector:  			; Increment And Validate Sense Sector Value
	movbi   bc,0c0h				; BC = Mask For Sector Num Validation
        movb    mc,[gc].97h			; MC = Sectors Per Track (17)
        ori     mc,3f00h			; MC != 3F00h => Max Sector Mask
        movb    ix,[gc].52h			; 44h or 48h - Current Drive SenseBytes Pointer
        addbi   ix,2h				; IX Pointed to SenseByte2: CylHi/Sect
        lcall   [gc],IncAndValidateSenseParmIX	; Increment and Validate Sector Number
        movb    [gc].50h,[gc+ix]		; Sector Value from Host = New Incremented Value
        andbi   [gc].50h,3fh			; Validate Sector Value from Host
        mov     tp,[gc].4h			; Return

;==========================================
IncAndValidateSenseParmIX:  
	incb    [gc+ix]				; Increment Sense Parameter Pointed by IX
        jmcne   [gc+ix],ParBoundOK		; Check it Bounds
        andb    [gc+ix],bc			; Validate Sense Parameter Pointed by IX if needed
        movbi   mc,0h				; Clear Mask as Corection Make Flag

ParBoundOK:  
	mov     tp,[gc]				; Return

;==========================================
IncValidSenseHeadAndCyl:  			; Increment and Validate Sense Head And Cylinder
	movb    ix,[gc].52h			; IX = 44h or 48h - Current Drive SenseBytes Pointer
        inc     ix				; IX Pointed to SenseByte1: Drive/Head
        movbi   bc,0e0h				; BC = Mask For Head Num Validation
        movb    mc,[gc].8ch			; MC = Max Head Num for Current HDD
        ori     mc,1f00h			; MC != 1F00h => Max Head Mask
        call    [gc],IncAndValidateSenseParmIX	; Increment and Validate Head Num
        jnz     mc,IncHdCylReturn		; If No Correction Applyed => Return
        addbi   ix,2h				; IX Pointed to SenseByte3: CylLo
        incb    [gc+ix]				; Inc CylLo
        jnzb    [gc+ix],IncHdCylReturn		; If No Overrun => Return
        dec     ix				; IX Pointed to SenseByte2: CylHi/Sect
        addbi   [gc+ix],40h			; Inc CylHi

IncHdCylReturn:  
	mov     tp,[gc].4h			; Return

;==========================================
Cmd_Read_Verify:	;GA=4,GB=8000h,GC=0	; Cmds 05 (Verify), 08 (Read), E5 (ReadLong)
        lcall   [gc],ChkDiskAddrValid		; Check if Addres on Disk received from Host is Valid
        lcall   [gc].4h,ChkDrvReady		; Check Drive Ready
        movb    [gc].3bh,gc			; ECC Burst Len = 0
        notb    mc,[gc].3eh			; MC = NOT HostCmd ([gc].3eh)
        addbi   mc,9h				; Add Complmenet Value for 8 - Read Cmd
        jz      mc,DoRetryAttempt		; If Read Cmd (No Long) => DoRetryAttempt
        incb    [gc].37h			; Inc Long Operation Flag

DoRetryAttempt:  
	lcall   [gc].0ch,ChkSectWeNeedAntItOK	; Check that we under track which needed and track structure are OK
        jmp     Do_Retry_Attempt		; Function above Returned OK        
Do_RetryAttempt:                                ; Function above Returned with Error
	lcall   [gc].0ch,RetryRcalbrRead_AM_ID	; Retry Do Recalibrate And Read AM_ID Again
        ljmp    DoRetryAttempt			; Do Retry Attempt

Do_Retry_Attempt:  
	lcall   [gc],DoReadDisk_520Bytes	; Do Read 520 Bytes From Disk ; GA = End OF Sector Data + ECC
        jmp     ReadWasOK			; Function above Returned OK        
        jmp     Do_RetryAttempt                 ; Function above Returned with Error

ReadWasOK:  
	movbi   bc,0h				; BC = 0
        jnzb    [gc].37h,ContinueProcessing	; If Long Operation Flag => ContinueProcessing
        jbt     [gb].10h,4,ContinueProcessing	; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
	jbt     [gc].43h,6,AllRetryAttemptDone	; Control Byte from Host, Bit 7 = RetryDisable
        jnzb    [gc].32h,AllRetryAttemptDone	; BOOL RetryAttempt Non Zero = One Retry Attempt was Performed 
        notb    [gc].32h			; BOOL RetryAttempt = FFh
        jmp     DoRetryAttempt			; Do Retry Attempt

AllRetryAttemptDone:  
	lcall   [gc].8h,CheckIfCorrectableECC	; Chech if ECC Correctable
        jmp     ContinueProcessing		; Function above Returned OK        
        jmp     Do_RetryAttempt                 ; Function above Returned with Error

ContinueProcessing:  
	movi    mc,0ff05h			; Set Mask
        jmce    [gc].3eh,CmdWasVerify		; if ((HostCmd ^ 05) & FF) == 0) => CmdWasVerify. [gc].3eh = HostCmd
        movb    [gc].60h,bc			; Temporary Byte = BC
        lcall   [gc],ReadSectBuf_GA_17D		; Sector data (BC Bytes) will be transferred from RAM Location 17D to Host
        movb    [gc].65h,[gc].3eh		; Last Saved Class/OpCode from Host = Class/OpCode from Host
        movb    bc,[gc].60h			; BC = Temporary Byte

CmdWasVerify:  
	addbi   bc,-24	;0e8h			; BC -= 24
        jnz     bc,NoVerfErr			; Bc != 0 => NoVerfErr
        movbi   bc,18h				; CORRECTABLE ECC ERROR !!! The controller detected a correctable ECC error in the target field.
        ljmp    ErrorDetected			; Done with Error

NoVerfErr:  
	decb    [gc].42h			; Decrement SectNum/Interleave from Host
        ljzb    [gc].42h,FinishProcessToHostOK	; If (SectNum/Interleave from Host == 0) => FinishProcessToHostOK
        lcall   [gc],ClearVars			; Initial Clear Vars
        lcall   [gc].8h,NextSector		; Goto Next Sector With correction Head and Possible Cylinder, if needed
        jmp     DoRetryAttempt			; Function above Returned OK         => Do Retry Attempt
        mov     [gc].60h,bc			; Function above Returned with Error => Error Flag = BC
        addbi   [gc].60h,-21h			; Error Flag -= 21h (ILLEGAL DISK ADDRESS ERROR)
        ljnzb   [gc].60h,Do_RetryAttempt	; If (Error Flag != ILLEGAL DISK ADDRESS ERROR) => Do_RetryAttempt
        ljmp    ErrorDetected			; Done with Error

;==========================================
RetryRcalbrRead_AM_ID:  			; Retry Do Recalibrate And Read AM_ID Again
	decb    [gc].39h			; Decrement Retry Count ([gc].39h)
        jzb     [gc].39h,ToutDone		; If all attepts done - goto ToutDone
        mov     mc,[gc].39h			; MC = Retry Count
        dec     mc				; Decrement MC
        jnz     mc,SkipRecalibrate		; If no Last Attempt - go to SkipRecalibrate And Read AM ID
        lcall   [gc].8h,DrvRecalibrate		; Recalibrate Drive (Decremental Seek until Track0 Reached)
        lcall   [gc].8h,Read_AM_ID_Common	; Read AM ID in Common Case
SkipRecalibrate:  				; Function above Returned OK        
	mov     tp,[gc].0ch			; Function above Returned with Error

ToutDone:  
	movb    mc,[gc].3eh			; MC = HostCmd ([gc].3eh)
        addbi   mc,-0bh				; MC += Negative Seek Cmd Code
        jnz     mc,SkipSeekErr			; If Not Seek Cmd => SkipSeekErr
        movbi   bc,15h				; SEEK ERROR !!! The cylinder or head address (either or both) did not compare with the expected target address as a result of a seek.

SkipSeekErr:  
	ljmp    ErrorDetected			; Done with Error

;==========================================
ChkSectWeNeedAntItOK:  				; Check that we under track which needed and track structure are OK
	movb    [gc].35h,gc			; Zero SectorNotFoundFlag. Only Bit1 Used. [gc].35h
        movb    [gc].33h,[gc].97h		; Current Sector1 = Sectors Per Track (17)

Do_GoNext:  
	lcall   [gc],ReadAmID_12Bytes_TOut1	; Read Address Mark ID (AM ID, 12 Bytes) to RAM at Address 0E2h ??? With TimeOut1
        jmp     DoContinue			; Continue

DoRetError:  
	addbi   [gc].0ch,3h			; Prepare to Return Error
        mov     tp,[gc].0ch			; Return Error

DoContinue:  
	jbt     [gb].10h,4,AmIdEccIsZero	; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
	setb    [gc].35h,1			; Set SectorNotFoundFlag. Only Bit1 Used. Bit1 in [gc].35h
        decb    [gc].33h			; Decrement Current Sector1
        jnzb    [gc].33h,Do_GoNext		; If Not All Sectors Done => DoGoNext

IdIccErrRet:  
	movbi   bc,10h				; ID READ ERROR, ID ECC ERROR !!! The controller detected an ECC error in the target ID field on the disk.
        jbt     [gc].35h,1,DoRetError
        orbi    bc,14h				; SECTOR NOT FOUND ERROR !!! The controller found the correct cylinder and head, but not the target sector.
	jmp     DoRetError			; Return Error

AmIdEccIsZero:  
	not     mc,[gc].4dh			; MC = NOT Current CylHi 1
        add     mc,[gc].0f7h			; MC += CylHi From AM
        inc     mc				; MC ++
        jnz     mc,CheckToSeekError		; If (MC != 0) => CheckToSeekError
        movb    mc,[gc].4fh			; MC = Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR
        andbi   mc,7fh				; Deactivate ~REDWCUR Signal (Bit 7 = 0, Signal Inverted)
        ori     mc,1f00h			; Set Mask. ATTENTION: BYTE/WORD COMBINED IN MC !!!
        jmcne   [gc].0f9h,CheckToSeekError	; HeadNum From AM
        movbi   mc,3eh				; MC = 3Eh
        addb    mc,[gc].0f6h			; GA += 0C2H. Address Mark ID (=C2h)
        jz      mc,GoToNoErr			; In normal Case = 0. Otherwise - Error

CheckToSeekError:  
	movbi   bc,15h				; SEEK ERROR !!! The cylinder or head address (either or both) did not compare with the expected target address as a result of a seek.
        jnzb    [gc].34h,DoRetError		; If(Seek Error Was Occured Flag != 0) Return Error
        notb    [gc].34h			; Set Seek Error Was Occured Flag
        lcall   [gc].8h,Read_AM_ID_Common	; Read AM ID in Common Case
        jmp     ChkSectWeNeedAntItOK		; Function above Returned OK        ; Check that we under track which needed and track structure are OK
        jmp     DoRetError			; Function above Returned with Error

GoToNoErr:  
	jbt     [gc].0fbh,1,RetBadTrkError	; If Bad Sector - Return Error. AM ID Flag: 80h-Normal,81h-Remapped,82h-BAD,9Xh-LastSector
        notb    mc,[gc].0fah			; MC = NOT SectorNum From AM
        addb    mc,[gc].50h			; Sector Value from Host
        inc     mc				; Increment MC
        jz      mc,ChkLastSect			; If Zero => ChkLastSect
        decb    [gc].33h			; Dec Current Sector1
        jzb     [gc].33h,IdIccErrRet		; If All Sectors Done => IdIccErrRet
        jbt     [gc].0fbh,4,WaitIndAndNext	; If Last Sector => WaitIndAndNext. AM ID Flag: 80h-Normal,81h-Remapped,82h-BAD,9Xh-LastSector
        movb    bc,[gc].94h			; Timeout After AM ID Readed

DoWaitTOut1:  
	dec     bc				; Decrement Timeout
        jnz     bc,DoWaitTOut1			; Loop until No Zero
        ljmp    Do_GoNext			; Goto Do_GoNext

WaitIndAndNext:  
        lcall   [gc],DoWaitIndex		; Do Wait Index Signal from Drive
	ljmp    Do_GoNext			; Go Next

ChkLastSect:  
	jbt     [gc].0fbh,4,WaitIndAndRet	; No Last Sector => WaitIndAndRet. AM ID Flag: 80h-Normal,81h-Remapped,82h-BAD,9Xh-LastSector
        movb    bc,[gc].95h			; Timeout After Last Sector AM ID Readed

DoWaitTOut2:  
	dec     bc				; Decrement Timeout
        jnz     bc,DoWaitTOut2			; Loop until No Zero
        jmp     Return_OK			; Goto Return_OK

WaitIndAndRet:  
        lcall   [gc],DoWaitIndex		; Do Wait Index Signal from Drive

Return_OK:  
	mov     tp,[gc].0ch			; Return

RetBadTrkError:  
	movbi   bc,19h				; BAD TRACK ERROR !!! The controller detected a bad track flag during the last operation. No retries are attempted on this error.
        ljmp    DoRetError			; Return Error

;==========================================
Cmd_RamDiag:		;GA=4,GB=8000h,GC=0	; Cmd E0 (RAM Diagnostic)
        movi    ix,400h				; Pointed to End of RAM (End of 1-st Kilobyte, 2x 541RU2)
        movi    mc,0aa55h			; Test Pattern

RamDiag_Loop:  
	addbi   ix,-2				; Index to Current Testing Word (Decremental)
        mov     bc,[gc+ix]			; BC = Current Testing Word
        mov     [gc+ix],mc			; Current Testing Word = MC
        not     mc				; Complement MC
        add     [gc+ix],mc			; Current Testing Word += MC
        inc     [gc+ix]				; Current Testing Word ++
        jnz     [gc+ix],RamErrorDetected	; If No Zero => RamErrorDetected
        mov     [gc+ix],mc			; Current Testing Word = New MC     
        not     mc                              ; Complement New MC                 
        add     [gc+ix],mc                      ; Current Testing Word += New MC    
        inc     [gc+ix]                         ; Current Testing Word ++       
        jnz     [gc+ix],RamErrorDetected        ; If No Zero => RamErrorDetected
        mov     [gc+ix],bc			; Reatore Current Testing Word
        jnz     ix,RamDiag_Loop			; Loop for ALL RAM Words
        movbi   gc,0h				; GC = 0
        ljmp    FinishProcessToHostOK		; Done

RamErrorDetected:  
	movbi   gc,0h				; GC = 0
	movbi   bc,30h				; RAM ERROR !!! The controller detected a data error during the RAM sector-buffer diagnostic test.
        ljmp    ErrorDetected			; Done with Error

;==========================================
CalcRomCrc:  
	movi    ix,0ffeh			; CRC Calculation Region End Offset
        movi    ga,0f000h			; CRC Calculation Region Start

	movbi   mc,0h				; CRC = 0

CalcCrcLoop:  
	addbi   ix,-2				; Decremental Next Word Index for CRC Calculation
        add     mc,[ga+ix]			; Add Word to CRC
        jnz     ix,CalcCrcLoop			; Not All Word are Calculated => Loop
        mov     tp,[gc]				; Return

;==========================================
DoReadDisk_520Bytes:  				; Do Read 520 Bytes From Disk ; GA = End OF Sector Data + ECC
	movi    ix,4000h			; VZ2/Xebec Serdes Base
        movbi   [gb].10h,36h			; Bit3 = 0 => VZ2/Xebec Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movi    mc,0ffc2h			; C2h = AM ID. Set Mask To future compare
        movi    bc,2ffh				; Timeout for i8089 External signal terminated transfer
        movb    [gb].8h,mc			; CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
        movi    ga,176h				; Sector Buffer - x ???
        movi    gb,976h	; Real Addr=177h	; A0 = A11 here (See H13 Mux on Schematic). Real Address is 0000 0001 0111 0111 = 177
						; MUX Ctrl = Port [gb].10h, Bit03. If 1 => Normal Opn, If 0 => VZ2/Xebec Opn 
						; At the same time, the RAM write enable signal is switched by the same multiplexer to the VZ2/Xebec read signal.
						; As a result, the following DMA transfer cycle writes information from VZ2/Xebec to RAM.
						; I think that this is resolve three problems simultaneously.
						; We must have another address than the source address (if source address is equal to destination 
						; address, i8089 may be do not anything), this addres must be under control, not enough set A0 to 
						; groung (A11 under our control) and this must be A0 to avoid increment addressing during transfer.
        jnzb    [gc].37h,Read520SkipIncPtr	; If Long Operation Flag => Read520SkipIncPtr
        addbi   ga,4h				; GA += 4
        addbi   gb,4h				; GB += 4

Read520SkipIncPtr:  
	movbi   [ga],55h			; Destroy AM ID Value for future check
        movi    cc,0448h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs4, BC/0 !! from [GB].Port to [GA].Port. ChannelControlRegister= 00 0 00 1 0 0 0 10 01 000
        xfer    				; Do xfer on next instruction
        movbi   [gc+ix],90h			; VZ2/Xebec Serdes Cmd 90h (???) (NOT Same as on 1841.0004/0018)
        ljmp    AmNotFoundError			; Off +0 => BC Expired (TimeOut). This Command id 4 bytes length                                    
        xfer                                    ; Off +4 => Previous Transfer OK, do Next Transfer - SINGLE Item Only.
        movi    cc,4680h			; Set Transfer !! SINGLE ITEM, NoBC, LOCK !! from [GB].Mem to [GA].Port. ChannelControlRegister= 01 0 00 1 1 0 1 00 00 000
        movbi   [gc+ix],10h			; VZ2/Xebec Serdes Cmd 10h (Set Transfer Direction Serdes => Host) (Same as on 1841.0004/0018)
        jmcne   [ga],AmIdEccError		; [GA] != C2h (AM ID) => AmIdEccError
        inc     ga				; GA++
        inc     ga				; GA++
        movbi   [gc+ix],80h			; VZ2/Xebec Serdes Cmd 80h (Start AM Detection, if success - xfer full AM field include CHS Address to i8089 RAM) (Same as on 1841.0004/0018)
        xfer    				; Do xfer on next instruction
        movi    cc,0c220h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs0, NoBC, LOCK !! from [GA].Mem to [GB].Mem. ChannelControlRegister= 11 0 00 0 1 0 0 01 00 000
        ljmp    Read520RetOK			; Return OK

AmNotFoundError:  
	movbi   bc,12h				; AM NOT FOUND ERROR !!! The controller did not detect the target address mark (AM) on the disk.
        jmp     Read520RetErr			; Do return Error

AmIdEccError:  
	movbi   bc,10h				; ID READ ERROR, ID ECC ERROR !!! The controller detected an ECC error in the target ID field on the disk.

Read520RetErr:  
        addbi   [gc],3h				; Prepare to Return Error

Read520RetOK:  
	movb    [gc+ix],gc			; VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018)
        movi    gb,8000h			; Restore GB to Board Ports
        mov     tp,[gc]				; Return

;==========================================
DoWriteDisk_518Bytes:  
	movi    ix,400fh			; 4010h - 1. Later added 4000h and result is 800F. As WORD this is contain and 8010 (former [gb].10h) ;8008
        movbi   [gb].10h,36h			; Bit3 = 0 => VZ2/Xebec Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movi    mc,0ffc2h			; C2h = AM ID. Set Mask To future compare
        movi    bc,2ffh				; Timeout for i8089 External signal terminated transfer
        movb    [gb].8h,mc			; CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
        movi    ga,178h				; Sector Buffer - x ???
        movi    gb,976h	; Real Addr=177h	; A0 = A11 here (See H13 Mux on Schematic). Real Address is 0000 0001 0111 0111 = 177
						; MUX Ctrl = Port [gb].10h, Bit03. If 1 => Normal Opn, If 0 => VZ2/Xebec Opn 
						; At the same time, the RAM write enable signal is switched by the same multiplexer to the VZ2/Xebec read signal.
						; As a result, the following DMA transfer cycle writes information from VZ2/Xebec to RAM.
						; I think that this is resolve three problems simultaneously.
						; We must have another address than the source address (if source address is equal to destination 
						; address, i8089 may be do not anything), this addres must be under control, not enough set A0 to 
						; groung (A11 under our control) and this must be A0 to avoid increment addressing during transfer.
        jnzb    [gc].37h,Wr518NoLong		; If Long Operation Flag => Wr518NoLong
        addbi   ga,4h				; GA += 4
        addbi   gb,4h				; GB += 4

Wr518NoLong:  
	movbi   [ga],55h			; Destroy AM ID Value for future check
        movi    cc,0048h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs4, BC/0 !! from [GA].Port to [GB].Port. ChannelControlRegister= 00 0 00 0 0 0 0 10 01 000
        movi    gc,4000h			; VZ2/Xebec Serdes Base
        xfer    
        movbi   [gc],90h			; VZ2/Xebec Serdes Cmd 90h (???) (NOT Same as on 1841.0004/0018)
        ljmp    AM_Det_Err05			; Off +0 => BC Expired (TimeOut). This Command id 4 bytes length                                    
        xfer                                    ; Off +4 => Previous Transfer OK, do Next Transfer - SINGLE Item Only.
        movi    cc,0c680h			; Set Transfer !! SINGLE ITEM, NoBC, LOCK !! from [GB].Mem to [GA].Mem. ChannelControlRegister= 11 0 00 1 1 0 1 00 00 000
        movb    [gc+ix+],mc			; WORD [800Fh] = FFC2h, ??? 800F==8008 ??? [8010h] (former [gb].10h) = FFh, IX = 4010h; ; ??? Bit3 = 1 => Normal Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        jmcne   [gb],Wr518IdReadErr		; (([GB] ^ C2) & FF) != 0) => Wr518IdReadErr
        movbi   [gc],41h			; VZ2/Xebec Serdes Cmd 41h (AM2 ???) (Same as on 1841.0004/0018)
        movi    cc,0c620h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs0, NoBC, LOCK !! from [GB].Mem to [GA].Mem. ChannelControlRegister= 11 0 00 1 1 0 0 01 00 000
        movbi   [gc+ix],25h			; [8010h] (former [gb].10h) = 25h ; Bit3 = 0 => VZ2/Xebec Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        xfer    				; Do transfer on next instruction
        nop     				; Really start transfer here
        movbi   [gc],0h				; VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018)
        movbi   gc,0h				; Restore GC = 0
        jmp     Wr518Exit			; return OK

AM_Det_Err05:  
	movbi   bc,12h				; AM NOT FOUND ERROR !!! The controller did not detect the target address mark (AM) on the disk.
        jmp     Wr518RetErr			; Return Error

Wr518IdReadErr:  
	movbi   bc,10h				; ID READ ERROR, ID ECC ERROR !!! The controller detected an ECC error in the target ID field on the disk.

Wr518RetErr:  
	movbi   [gc],0h				; VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018)
        movbi   gc,0h				; Restore GC = 0
        addbi   [gc],3h				; Prepare to return Error

Wr518Exit:  
	movi    gb,8000h			; Restore GB to Board Ports
        mov     tp,[gc]				; Return

;==========================================
Cmd_Write:		;GA=4,GB=8000h,GC=0	; Cmds 0A (Write), E6 (Write Long)
        lcall   [gc],ChkDiskAddrValid		; Check if Addres on Disk received from Host is Valid
        lcall   [gc].4h,ChkDrvReady		; Check Drive Ready
        notb    mc,[gc].3eh			; MC = NOT [gc].3eh = HostCmd (0A or E6) => (F5 or 19)
        addbi   mc,0bh				; If F5, then MC = 0, if 19, then MC = 24h
        jz      mc,WriteOpnRepeat		; If Write Opn (Not Long) => WriteOpnRepeat
        incb    [gc].37h			; Inc Long Operation Flag

WriteOpnRepeat:  
        lcall   [gc],WriteSectBuf		; Sector data (BC Bytes) will be transferred from Host to RAM Location
        movb    [gc].65h,[gc].3eh		; Last Saved Class/OpCode from Host = Class/OpCode from Host
        movi    ix,179h				; Sector Buffer + ???
        jnzb    [gc].37h,WrDoOpn		; If Long Operation Flag => WrDoOpn
        addbi   ix,4h				; IX += 4

WrDoOpn:  
	movbi   [gc+ix+],1h			; BYTE Sector Buffer[0] = 1
        mov     [gc+ix+],gc			; WORD Sector Buffer[1] = 0

WrChkSectAgain:  
	lcall   [gc].0ch,ChkSectWeNeedAntItOK	; Check that we under track which needed and track structure are OK
        jmp     WrChkSectOK			; Function above Returned OK        

WrRetryRclbrRdAmID:				; Function above Returned with Error
	lcall   [gc].0ch,RetryRcalbrRead_AM_ID	; Retry Do Recalibrate And Read AM_ID Again
        jmp     WrChkSectAgain			; Check that we under track which needed and track structure are OK Again

WrChkSectOK:  
	lcall   [gc],DoWriteDisk_518Bytes	; Do Write 518 Bytes To Disk
        jmp     WrDiskWasOK			; Function above Returned OK        
        jmp     WrRetryRclbrRdAmID		; Function above Returned with Error

WrDiskWasOK:  
	decb    [gc].42h			; Decrement SectNum/Interleave from Host
        ljzb    [gc].42h,FinishProcessToHostOK	; If SectNum/Interleave from Host is Zero => FinishProcessToHostOK
        lcall   [gc],ClearVars			; Initial Clear Vars
        lcall   [gc].8h,NextSector		; Goto Next Sector With correction Head and Possible Cylinder, if needed
        jmp     WriteOpnRepeat			; Function above Returned OK         => WriteOpnRepeat
                                                ; Function above Returned with Error => Continue next instruction
        movb    [gc].60h,bc			; Error Flag = BC (Error Code after upper NextSector call)
        addbi   [gc].60h,-21h			; Error Flag -= 21h (ILLEGAL DISK ADDRESS ERROR)
        jnzb    [gc].60h,WrRetryRclbrRdAmID	; If (Error Flag != ILLEGAL DISK ADDRESS ERROR) => WrRetryRclbrRdAmID
        ljmp    ErrorDetected			; Done with Error

;==========================================
Cmd_ReadSectBuf:	;GA=4,GB=8000h,GC=0	; Cmd 0E (Read Data from Sector Buffer)
        movbi   [gc].4ch,18h			; Set Port 18h Saved Value by Default. SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movi    mc,0ff05h			; MC = Mask
        jmce    [gc].65h,PrevCmd_ReadOrReadVerf	; ((Last Saved Class/OpCode from Host ^ 05) & FF) == 0 => PrevCmd_ReadOrReadVerf	; 05 (Ready Verify)
        movi    mc,0ff08h			; MC = Mask
        jmce    [gc].65h,PrevCmd_ReadOrReadVerf	; ((Last Saved Class/OpCode from Host ^ 08) & FF) == 0 => PrevCmd_ReadOrReadVerf	; 08 (Read)
        movi    mc,0ffe6h			; MC = Mask
        jmcne   [gc].65h,PrevWasLongOperations	; ((Last Saved Class/OpCode from Host ^ E6) & FF) != 0 => PrevCmd_ReadOrReadVerf	; E6 (Write Long)

        movi    ga,17ch				; Sector Buffer - 1
        incb    [gc].37h			; Inc Long Operation Flag
        lcall   [gc],ReadSectBuf		; BC Bytes from RAM pointed by GA will be transferred to Host
        ljmp    FinishProcessToHostOK		; Done

PrevWasLongOperations:  
	movi    mc,0ffe5h			; MC = Mask
        jmcne   [gc].65h,PrevWasNoReadLongOpn	; ((Last Saved Class/OpCode from Host ^ E5) & FF) != 0 => PrevWasNoReadLongOpn		; E5 (Read Long)
        incb    [gc].37h			; Inc Long Operation Flag

PrevCmd_ReadOrReadVerf:  
        lcall   [gc],ReadSectBuf_GA_17D		; Sector data (BC Bytes) will be transferred from RAM Location 17D to Host
        ljmp    FinishProcessToHostOK		; Done

PrevWasNoReadLongOpn:  
	lcall   [gc],ReadSectBuf_GA_180		; Sector data (BC Bytes) will be transferred from RAM Location 180h to Host
        ljmp    FinishProcessToHostOK		; Done

;==========================================
Cmd_WriteSectBuf:	;GA=4,GB=8000h,GC=0	; Cmd 0F (Write Data to Sector Buffer)
        movbi   [gc].4ch,18h			; Set Port 18h Saved Value by Default. SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        lcall   [gc],WriteSectBuf		; Sector data (BC Bytes) will be transferred from Host to RAM Location
        movb    [gc].65h,[gc].3eh		; Last Saved Class/OpCode from Host = Class/OpCode from Host
        ljmp    FinishProcessToHostOK		; Done

;==========================================
Cmd_Seek:		;GA=4,GB=8000h,GC=0	; Cmd 0B (Seek)
        lcall   [gc],ChkDiskAddrValid		; Check if Addres on Disk received from Host is Valid
        lcall   [gc].4h,ChkDrvReady		; Check Drive Ready
        lcall   [gc].8h,Read_AM_ID_Common	; Read AM ID in Common Case
        jmp     SkRdAmIdNoFmtAgain		; Function above Returned OK        
        jmp     SkRtryRclbrRdAmID		; Function above Returned with Error

SkRdAmIdNoFmtAgain:  
	lcall   [gc].4h,Read_AM_ID_NoFmtOpn	; Read AM ID For Non-Format Operation
        jmp     ChkIfAllDone			; Function above Returned OK        
        jmp     SkRtryRclbrRdAmID		; Function above Returned with Error

ChkIfAllDone:  
	not     mc,[gc].0f7h			; MC = NOT CylHi From AM
        add     mc,[gc].4dh			; MC += Current CylHi 1
        inc     mc				; MC ++
        jnz     mc,SkRtryRclbrRdAmID		; MC != 0 => SkRtryRclbrRdAmID
        ljmp    FinishProcessToHostOK		; Done

SkRtryRclbrRdAmID:  
	lcall   [gc].0ch,RetryRcalbrRead_AM_ID	; Retry Do Recalibrate And Read AM_ID Again
        jmp     SkRdAmIdNoFmtAgain		; Read_AM_ID_NoFmtOpn Again

;==========================================
Cmd_ReadEccBurst:	;GA=4,GB=8000h,GC=0	; Cmd 0D (Read ECC Burst Error Length)
        movbi   [gb].18h,38h			; SELECT/NO DIAG/IN/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        movb    [gb],[gc].3bh			; Host Data Port (Read Data from Host [Host Port 320h]) (CHIP B11) = ECC Burst Len
        movbi   [gb].18h,18h			; SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        ljmp    FinishProcessToHostOK		; Done

;==========================================
Cmd_DriveDiag:		;GA=4,GB=8000h,GC=0	; Cmd E3 (Drive Diagnostic)
        lcall   [gc].4h,CheckDrvReady		; Check Drive Ready
        lcall   [gc].8h,DrvRecalibrate		; Recalibrate Drive (Decremental Seek until Track0 Reached)
        lcall   [gc],GetDrvSenseBytesPtr	; Get Current Drive SenseBytes Pointer to IX (44h or 48h), Also store IX in [gc].52h (CurDrvSenseBytesPtr)
        inc     ix				; IX Pointed to SenseByte1: Drive/Head
        andbi   [gc+ix+],0e0h			; Mask Head Only, IX Pointed to WORD (SenseByte2: CylHi/Sect, SenseByte3: CylLo)
        mov     [gc+ix],gc			; Clear WORD Sect/Cyl in Sense Bytes
        mov     [gc].4dh,gc			; Clear WORD Current Cyl1. WORD([gc].4dh, [gc].4eh) = 0	
        mov     [gc].4fh,gc			; Clear Both Board Port 39 Value (Chip H14) InMem = ~HDx/~Step/~Dir/~REDWRC And Sector Value from Host [gc].50h
        mov     [gc].56h,gc			; Clear WORD Current Cyl2. WORD([gc].56h, [gc].57h) = 0
        movbi   [gc].31h,80h			; Last Occured SenseByte0 for any drive = 80h (AddressValid)

DrDgChkSectWeNeedOK:  
	lcall   [gc].0ch,ChkSectWeNeedAntItOK	; Check that we under track which needed and track structure are OK
        jmp     DrDgGoToNextHead		; Function above Returned OK        
                                                ; Function above Returned with Error (Continue Instructions Bottom)
        movb    [gc].60h,bc			; Error Flag = BC (Error Code from Last Opertaion above). [gc].60h = BC
        addbi   [gc].60h,-19h			; Error Flag -= 19h. [gc].60h				!!! Check - on 1841 here Error ???
        jzb     [gc].60h,DrDgGoToNextHead	; If No Errors => DrDgGoToNextHead. [gc].60h

DrDgRetryRclbrRdAmID:  
	lcall   [gc].0ch,RetryRcalbrRead_AM_ID	; Retry Do Recalibrate And Read AM_ID Again
        jmp     DrDgChkSectWeNeedOK		; Check that we under track which needed and track structure are OK Again

DrDgGoToNextHead:  
	lcall   [gc],ClearVars			; Initial Clear Vars
        lcall   [gc].8h,NextHead		; Goto Next Head With Correction Cylinder, if needed
        jmp     DrDgChkSectWeNeedOK		; Check that we under track which needed and track structure are OK Again

        mov     [gc].60h,bc			; Error Flag = BC (Error Code from Last Opertaion above). [gc].60h = BC
        addbi   [gc].60h,-21h			; Error Flag -= 21h (ILLEGAL DISK ADDRESS ERROR !!!). [gc].60h. 
        jnz     [gc].60h,DrDgRetryRclbrRdAmID	; If (Error Flag == ILLEGAL DISK ADDRESS ERROR) +> DrDgRetryRclbrRdAmID. [gc].60h     
        ljmp    FinishProcessToHostOK		; Done

;==========================================
CheckIfCorrectableECC:  			; GA = End OF Sector Data + ECC - 5. Possible ECC
	movb    [gc].67h,gc			; Clear ECC Correctable Flag (Evaluation in Progress)
        movb    mc,[gb].20h			; Start i8089 Channel 2 (Code Below). (Readed Data is Irrelevant, Read Acces is enough) (CHIPS K08, D03)

WaitEccEvalDone:  
	jzb     [gc].67h,WaitEccEvalDone	; Wait ECC Correctable Flag != 0 (ECC Evaluation Done - See Chan2 Routine)
        movi    mc,0ff18h			; Mask
        jmce    [gc].67h,EccIsCorrectable	; ECC Correctable Flag == 18h (Correctable ECC Error) => EccIsCorrectable; (([gc].67h ^ 18h) & FFh) == 0 => EccIsCorrectable

        addbi   [gc].8h,3h			; Prepare to return Error (ECC No Correctable)

EccIsCorrectable:  
	mov     bc,[gc].67h			; Set Return Value

        mov     tp,[gc].8h			; Return

;==============================================================================================================================================================
; === Channel 2 Routine start (E9E3), Starting every time when 8089 Pin 23 (CA) is Activated and Pin 24 (SEL)=1. Using Pin 32 (Ext2=>Err) for cancel DMA xfer
;==============================================================================================================================================================
Chan2_Start:					; Used as Error Handler, do check if ECC Correctable or Not Correctable
        movi    cc,0308h			; Set Transfer Block of BC Bytes, Lock, HiPrio, from [GA].Port to [GB].Port. ChannelControlRegister= 00 0 00 0 1 1 0 00 01 000
        movi    ix,3ff0h			; 4000h - 10h
        movi    gb,8000h			; GB Points to Board Ports
        movbi   [gb].10h,0a3h			; Bit3 = 0 => VZ2/Xebec Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movbi   gc,10h				; GC = 10h. Used for separate Stack for this Channel 2 Routine
        movbi   [gc+ix+],0h			; VZ2/Xebec Serdes Base (4000h); VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018)
        movbi   [gc+ix],20h			; VZ2/Xebec Serdes Base + 1 (Port1 4001h) = 20h ???

        movbi   ga,6ah				; Chan2 ECC Result Packet
        movbi   gb,6ah				; Chan2 ECC Result Packet
        wid     16,16				; 16 Bit transfer
        xfer    				; Start xfer on next instruction
        movi    bc,97a8h			; BC = Bytes to transfer (38 824 Bytes) - I THINK THIS IS DELAY ONLY FOR VZ2/XEBEC ENABLE SOME TIME (LOCK SIGNAL IS ACTIVE)

        movi    gb,8000h			; GB Point to Board Ports
        movbi   [gc+ix],0h			; VZ2/Xebec Serdes Base + 1 (Port1 4001h) = 00h ???
        movbi   [gb].10h,0bbh			; Bit3 = 1 => Normal Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movbi   gb,6ah				; Chan2 ECC Result Packet
        movi    cc,0330h			; Set Transfer Block of BC Bytes, !! UNTIL EXT SIGNAL/Offs40 BC/4 Lock, HiPrio !!!, from [GA].Port to [GB].Port. ChannelControlRegister= 00 0 00 0 1 1 0 01 10 000
        wid     8,8				; 8 Bit transfer
        xfer    				; Start xfer on next instruction
        movi    bc,1039h			; Timeout for i8089 External signal terminated transfer
        ljmp    Chan2_XferOK			; Off +0 => Previous Transfer OK, Continue. This Command id 4 bytes length.
Chan2_TOut:  					; Off +4 => BC Expired (TimeOut). 
	movbi   [gc].57h,11h                    ; Set  = ECC Correctable Flag = 11h (ECC Uncorrectable Error); GC = 10h. Address from GC=0 is [gc].67h !!!
        hlt     				; Stop Channel 2 Routine

Chan2_XferOK:  
	nop     				; No Operation
        dec     ix				; IX = 4000 (VZ2/Xebec Serdes Base)
        movb    [gc].5ah,[gc+ix+]		; GC not 0 but 10h, Real Address is [gc].6ah : Chan2 - ECC Result Packet Byte 1 = VZ2/Xebec Serdes Base (4000h) IX++
        movb    mc,[gc+ix]			; MC = VZ2/Xebec Serdes Base + 1 (Port1 4001h) Value (Bits [2-0] !=0 When ECC Error)
        andbi   mc,7h				; Mask only 3 low bits
        movb    [gc].5bh,mc			; GC not 0 but 10h, Real Address is [gc].6Bh : Chan2 - ECC Result Packet Byte 2 = MC
        movbi   [gc].5ch,0h			; GC not 0 but 10h, Real Address is [gc].6Ch : Chan2 - ECC Result Packet Byte 3 = 0
        mov     mc,[gc].5ah			; WORD GC not 0 but 10h, Real Address is [gc].6Ah + [gc].6Bh : MC = WORD ECC Result Packet Byte 1 + ECC Result Packet Byte 2
        mov     [gc].50h,mc			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : Chan2 Accum = MC
        mov     [gc].60h,bc			; WORD GC not 0 but 10h, Real Address is [gc].70h + [gc].71h : Chan2 Temporary Word = BC

        movbi   bc,16				; Counter

DoAccumulate:  
	add     mc,[gc].50h			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : MC += Chan2 Accum
        mov     [gc].50h,mc			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : Chan2 Accum = MC
        dec     bc				; Decrement counter (16)
        jz      bc,Chan2_TOut			; If Counter is Zero => ECC Correctable Flag = 11h (ECC Uncorrectable Error) and Stop Channel 2 Routine
        jnbt    [gc].51h,7,DoAccumulate		; If Bit7 of Chan2 Accum is Zero => DoAccumulate
        movb    [gc].2bh,bc			; GC not 0 but 10h, Real Address is [gc].3Bh : ECC Burst Len = BC
        not     bc				; NOT BC
        addb    bc,[gc].77h			; GC not 0 but 10h, Real Address is [gc].87h : BC += Active HDD Param Table ECC Burst Len
        inc     bc				; Increment BC
        andbi   bc,80h				; BC &= 80h
        jz      bc,BurstNoOverflow		; If no Overflow - continue
        jmp     Chan2_TOut			; Else - Set ECC Correctable Flag = 11h (ECC Uncorrectable Error) and Stop Channel 2 Routine

BurstNoOverflow:  
	mov     mc,[gc].60h			; WORD GC not 0 but 10h, Real Address is [gc].70h + [gc].71h : MC = Chan2 Temporary Word
        andi    mc,0fff8h			; MC & = FFF8h
        mov     [gc].50h,mc			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : Chan2 Accum = MC

        movbi   bc,13				; Counter

DoManipulateAgain:  
	jnbt    [gc].51h,7,SkipSetZeroBit	; If Bit7 of Chan2 Accum is Zero => SkipSetZeroBit
        setb    [gc].50h,0			; Bit8 of WORD Chan2 Accum = 0

SkipSetZeroBit:  
	dec     bc				; Decrement counter (13)
        jz      bc,ManupaltionDone		; If Zero => ManupaltionDone
        mov     mc,[gc].50h			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : MC = Chan2 Accum
        add     mc,[gc].50h			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : MC += Chan2 Accum (MC = Chan2 Accum * 2)
        mov     [gc].50h,mc			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : Chan2 Accum = Chan2 Accum * 2
        jmp     DoManipulateAgain		; Do Manipulate Again

ManupaltionDone:  
	mov     ix,[gc].50h			; WORD GC not 0 but 10h, Real Address is [gc].60h + [gc].61h : IX = Chan2 Accum
        andi    ix,7fffh			; IX &= 7FFF
        not     ix				; NOT IX
        addi    ix,371h				; WORD GC not 0 but 10h, Real Offset is [gc].381h : Sector Data ECC ???

        movb    bc,[gc].60h			; WORD GC not 0 but 10h, Real Address is [gc].70h + [gc].71h : BC = Chan2 Temporary Word
        andbi   bc,7h				; BC &= 7 - Counter

DoNextIteration:  
	jz      bc,DoCorrectECC			; If Counter is Zero => DoCorrectECC
        movb    mc,[gc].5ch			; GC not 0 but 10h, Real Address is [gc].6Ch : MC = ECC Result Packet Byte 3
        addb    mc,[gc].5ch			; GC not 0 but 10h, Real Address is [gc].6Ch : MC += ECC Result Packet Byte 3 (MC = ECC Result Packet Byte 3 * 2)
        movb    [gc].5ch,mc			; GC not 0 but 10h, Real Address is [gc].6Ch : ECC Result Packet Byte 3 = ECC Result Packet Byte 3 * 2
        jnbt    [gc].5bh,7,SkipSetZeroBit2	; If Bit7 of Chan2 - ECC Result Packet Byte 2 is Zero => SkipSetZeroBit. GC not 0 but 10h, Real Address is [gc].6Bh
        setb    [gc].5ch,0			; Set Bit0 of Chan2 - ECC Result Packet Byte 2 to Zero.                  GC not 0 but 10h, Real Address is [gc].6Ch

SkipSetZeroBit2:  
	mov     mc,[gc].5ah			; GC not 0 but 10h, Real Address is [gc].6Ah : MC = ECC Result Packet Byte 1
        add     mc,[gc].5ah			; GC not 0 but 10h, Real Address is [gc].6Ah : MC += ECC Result Packet Byte 1 (MC = ECC Result Packet Byte 1 * 2)
        mov     [gc].5ah,mc			; GC not 0 but 10h, Real Address is [gc].6Ah : ECC Result Packet Byte 1 = ECC Result Packet Byte 1 * 2
        dec     bc				; Decrement Counter
        jmp     DoNextIteration			; Do Next Iteration

DoCorrectECC:  
	movbi   ga,6ah				; Chan2 ECC Result Packet
        call    [gc],EccAlgTransform		; Do Transform
        inc     ga				; GA++
        dec     ix				; IX--
        call    [gc],EccAlgTransform		; Do Transform
        inc     ga				; GA++
        dec     ix				; IX--
        call    [gc],EccAlgTransform		; Do Transform
        movbi   [gc].57h,18h			; Set  = ECC Correctable Flag = 18h (ECC Correctable Error); GC = 10h. Address from GC=0 is [gc].67h !!!
        hlt     				; Stop Channel 2 Routine

;==========================================
EccAlgTransform:  
	notb    mc,[gc+ix]			; MC = NOT ECC BYTE
        andb    mc,[ga]				; MC &= Oher ECC BYTE
        notb    gb,[ga]				; GB = NOT Oher ECC BYTE
        andb    gb,[gc+ix]			; GB &= ECC BYTE
        movb    [gc+ix],mc			; [Sector Data ECC ???] = MC
        orb     [gc+ix],gb			; [Sector Data ECC ???] |= GB
        mov     tp,[gc]				; Return

;==========================================
Cmd_Format:		;GA=4,GB=8000h,GC=0	; Cmds 04 (Format Drive), 06 (Format Track), 07 (Format Bad Track)
        incb    [gc].36h			; Activate Format Command Active Flag (0/1)
        lcall   [gc],FmtCmdChkParmSetLayout	; Check Parameters and Prepare Sector Layout Table (42 Bytes at 0B3h)
        lcall   [gc],ChkDiskAddrValid		; Check if Addres on Disk received from Host is Valid
        lcall   [gc].4h,ChkDrvReady		; Check Drive Ready
        movi    mc,0ff05h			; MC = Mask
        jmcne   [gc].65h,FmtLastCmdNoReadVerf	; ((Last Saved Class/OpCode from Host ^ 05) & FF) != 0) => FmtLastCmdNoReadVerf. (NO ReadVerify Command)
        movi    ga,17dh				; Sector Buffer ???
        jmp     FmtSectBufSetDone		; Sector Buf Set Done

FmtLastCmdNoReadVerf:  
	movi    mc,0ff08h			; MC = Mask
        jmcne   [gc].65h,FmtLastCmdNoRead	; ((Last Saved Class/OpCode from Host ^ 08) & FF) != 0) => FmtLastCmdNoRead. (NO Read Command)
        movi    ga,17dh				; Sector Buffer ???
        jmp     FmtSectBufSetDone		; Sector Buf Set Done

FmtLastCmdNoRead:  
	movi    mc,0ffe5h			; MC = Mask
        jmcne   [gc].65h,FmtLastCmdNoReadLong	; ((Last Saved Class/OpCode from Host ^ E5) & FF) != 0) => FmtLastCmdNoReadLong. (NO ReadLong Command)
        movi    ga,179h				; Sector Buffer - x ???
        jmp     FmtSectBufSetDone		; Sector Buf Set Done

FmtLastCmdNoReadLong:  
	movi    mc,0ffe6h			; MC = Mask
        jmcne   [gc].65h,FmtNextAttempt		; ((Last Saved Class/OpCode from Host ^ E6) & FF) != 0) => FmtNextAttempt. (NO WriteLong Command)
        movi    ga,17ch				; Sector Buffer - 1 ???

FmtSectBufSetDone:  
	movi    gb,180h				; Sector Buffer + 3 ???
        movi    ix,512				; Sector Size

FmtCopyData:  
	addbi   ix,-2				; IX -= 2
        mov     [gb+ix],[ga+ix]			; Copy Data
        jnz     ix,FmtCopyData			; Whole Sector

        movi    gb,8000h			; GB Point to Board Ports
        movb    [gc].65h,[gc].3eh		; Last Saved Class/OpCode from Host = Class/OpCode from Host

FmtNextAttempt:  
	lcall   [gc].8h,DrvRecalibrate		; Recalibrate Drive (Decremental Seek until Track0 Reached)
        lcall   [gc].8h,Read_AM_ID_Common	; Read AM ID in Common Case
        jmp     FmtAmReadedOK			; Function above Returned OK        
        ljmp    FmtAmReadedError		; Function above Returned with Error

FmtAmReadedOK:  
	movb    [gb].8h,mc			; CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
        movi    ix,4000h			; VZ2/Xebec Serdes Base
        lcall   [gc],DoWaitIndex		; Do Wait Index Signal from Drive
        movbi   [gc+ix],40h			; VZ2/Xebec Serdes Cmd 40h (Format Operation) (Same as on 1841.0004/0018)

        movi    bc,511				; Delay Counter

Delay511:  
	dec     bc				; Decrement Delay Counter
        jnz     bc,Delay511			; Do Delay Loop

        movi    [gc].0f8h,0c200h		; WORD CylHi/Lo From AM = 194
        movi    [gc].0f6h,1h			; Destroy Address Mark ID (Normally=C2h)
        movi    ix,17dh				; ???
        movbi   [gc+ix+],1h			; ???
        mov     [gc+ix],gc			; ???
        mov     [gc].0fah,[gc].4dh		; SectorNum From AM = ???
        movb    mc,[gc].4fh			; MC = Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR
        andbi   mc,9fh				; Mask ~DIR Bit
        movb    [gc].0fch,mc			; AM ID Zero Byte = 0
        movi    [gc].0feh,80h			; WORD ECC For AM ID Field LoWord ???
        movi    mc,0ff07h			; Set Mask
        jmcne   [gc].3eh,NoBadTrackFmtOpn	; ((HostCmd ^ 07h) & 0FFh) != 0) => NoBadTrackFmtOpn. [gc].3eh = HostCmd
        setb    [gc].0feh,1			; ECC For AM ID Field LoWord ???

NoBadTrackFmtOpn:  
	movi    [gc].64h,0b4h			; Format Sector Layouts Array Ptr = 42 Bytes Sector Layouts for Format Operation + 1
        movbi   [gb].10h,65h			; Bit3 = 0 => VZ2/Xebec Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movb    [gc].0fdh,gc			; ECC For AM ID Field LoWord = 0 ???
        mov     [gb].8h,mc			; CLEAR AM (Writted Data is Irrelevant, Write Acces is enough) (CHIP M05)
        wid     16,16				; 16-Bit Source to 16-Bit Destination
        notb    mc,[gc].97h			; MC = NOT Sectors Per Track (17)
        inc     mc				; MC ++ MC = -17, Sector Count

FmtOpnWaitIndex:  
	jbt     [gb].10h,6,FmtOpnWaitIndex	; Wait No Index. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)

FmtWaitIndLoop:  
	jnbt    [gb].10h,6,FmtWaitIndLoop	; Wait Index. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)

        movbi   bc,27				; Delay Counter

FmtOpnAfterIndexDelay:  
	dec     bc				; Decrement Delay Counter
        jnz     bc,FmtOpnAfterIndexDelay	; Do Delay Loop

FmtDoNextSector:  
	movi    ix,4000h			; VZ2/Xebec Serdes Base
        movi    ga,0f6h				; Offset of Address Mark ID = Address from get Full AM field include CHS Address
        movi    gb,8f6h	; Real Addr=0f7h	; A0 = A11 here (See H13 Mux on Schematic). Real Address is 0000 0000 1111 0111 = 0F7
						; MUX Ctrl = Port [gb].10h, Bit03. If 1 => Normal Opn, If 0 => VZ2/Xebec Opn 
						; At the same time, the RAM write enable signal is switched by the same multiplexer to the VZ2/Xebec read signal.
						; As a result, the following DMA transfer cycle writes information from VZ2/Xebec to RAM.
						; I think that this is resolve three problems simultaneously.
						; We must have another address than the source address (if source address is equal to destination 
						; address, i8089 may be do not anything), this addres must be under control, not enough set A0 to 
						; groung (A11 under our control) and this must be A0 to avoid increment addressing during transfer.
        movbi   [gc+ix],55h			; VZ2/Xebec Serdes Format Params (Format Operation) (Same as on 1841.0004/0018)
        movbi   [gc+ix],41h			; VZ2/Xebec Serdes Format Params (Format Operation) (Same as on 1841.0004/0018)
        movi    cc,0c220h			; Set Transfer Block of Bytes !! UNTIL EXT SIGNAL/Offs0, NoBC, LOCK !! from [GA].Mem to [GB].Mem. ChannelControlRegister= 11 0 00 0 1 0 0 01 00 000
        xfer    
        movbi   bc,6h				; Timeout for i8089 External signal terminated transfer
        inc     mc				; Increment Sector Counter
        jmcne   [gc].0d7h,FmtNotSetLast		; ((FF ^ MCLo) & MCHi) != 0 => NotLast. [gc].0d7h Used as Variable Contain 0FFh (Init in FmtCmdChkParmSetLayout)
        setb    [gc].0feh,4			; ECC For AM ID Field LoWord ???

FmtNotSetLast:  
	mov     ix,[gc].64h			; IX = Format Sector Layouts Array Ptr
        movb    [gc].0fdh,[gc+ix+]		; ECC For AM ID Field LoWord ??? = VZ2/Xebec Serdes Format Params (Format Operation) (Same as on 1841.0004/0018) IX++
        movb    [gc].64h,ix			; Format Sector Layouts Array Ptr = IX. VZ2/Xebec Serdes Format Params (Format Operation) (Same as on 1841.0004/0018)
        movi    ix,4000h			; VZ2/Xebec Serdes Base
        movb    [gc+ix],gc			; VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018)
        jz      mc,FmtAllSectDone		; All Sectors Done ? => FmtAllSectDone

        movb    bc,[gc].92h			; BC = Timeout1 For Format Operation

FmtOpnDelayLoop:  
	dec     bc				; Decrement Timeout
        jnz     bc,FmtOpnDelayLoop		; Loop until No Zero
        jmp     FmtDoNextSector			; Format Next Sector

FmtAllSectDone:  
	movi    gb,8000h			; Restore GB = 8000h, Point to Board Ports
        movi    mc,0ff07h			; Set Mask
        jmce    [gc].3eh,BadTrackFmtOpn		; ((HostCmd ^ 07h) & 0FFh) == 0) => BadTrackFmtOpn. [gc].3eh = HostCmd
        movb    [gc].62h,[gc].97h		; TemporarySector = Sectors Per Track (17)
        lcall   [gc],DoWaitIndex		; Do Wait Index

FmtWrtDskAgain:  
	lcall   [gc],DoWriteDisk_518Bytes	; Do Write 518 Bytes To Disk
        jmp     FmtWrtDskOK			; Function above Returned OK        
FmtAmReadedError:  				; Function above Returned with Error
	dec     [gc].39h
        ljnzb   [gc].39h,FmtNextAttempt		; If not all attepts done - Repeat
        ljmp    ErrorDetected			; Done with Error

FmtWrtDskOK:  
        decb    [gc].62h			; Decrement TemporarySector
        movb    mc,[gc].96h			; SectNum when FmtNotWaitIndex
        ori     mc,0ff00h			; Complete Mask
        jmcne   [gc].62h,FmtSkipWaitIndex	; ((TemporarySector ^ ???) & 0FFh) == 0 ?) => FmtSkipWaitIndex
        lcall   [gc],DoWaitIndex		; Do Wait Index Signal from Drive

FmtSkipWaitIndex:  
	jzb     [gc].62h,BadTrackFmtOpn		; TemporarySector == 0 ? => BadTrackFmtOpn
        mov     bc,[gc].98h			; BC = WORD Timeout2 For Format Operation

FmtWrtDelayLoop:  
	dec     bc				; Decrement Timeout
        jnz     bc,FmtWrtDelayLoop		; Loop until No Zero
        jmp     FmtWrtDskAgain			; Do Again

BadTrackFmtOpn:  
	lcall   [gc].4h,IncValidSenseHeadAndCyl	; Increment and Validate Sense Head And Cylinder
        movi    mc,0ff04h
        jmce    [gc].3eh,NoFmtTrkOrBadTrk	; Class/OpCode from Host

FmtFinishedOK:  
	ljmp    FinishProcessToHostOK		; Done

NoFmtTrkOrBadTrk:  				; Format Drive, Not Track/BadTrack
	lcall   [gc],ClearVars			; Initial Clear Vars
        lcall   [gc].8h,NextCyl			; Goto Next Cylinder (Seek to Next Cylinder)
        jmp     FmtDoAgain			; Function above Returned OK        
        jmp     FmtFinishedOK			; Function above Returned with Error

FmtDoAgain:  
	ljmp    FmtAmReadedOK			; Do Again

;==========================================
Cmd_CtrlrDiag:		;GA=4,GB=8000h,GC=0	; Cmd E4 (Controller Internal Diagnostics)
        lcall   [gc],CalcRomCrc			; MC = ROM CRC (0F000h->0FFFEh)
        not     mc
        add     mc,[pp].24h			; NC += stored ROM CRC for compare. PP = Chan1Start, [pp].24h = stored ROM CRC for compare
        inc     mc
        jz      mc,Diagnextstep1
        movbi   bc,31h				; ROM CRC ERROR !!! Program Memory Checksum Error: During this internal diagnostic test, the controller detected a program-memory checksum error.

Error_Detected:  
        ljmp    ErrorDetected			; Done with Error

Diagnextstep1:  
	movi    ix,4000h			; VZ2/Xebec Serdes Base
        movbi   [gc+ix],10h			; VZ2/Xebec Serdes Cmd 10h (Set Transfer Direction Serdes => Host) (Same as on 1841.0004/0018)
        movb    [gc+ix+],gc			; VZ2/Xebec Serdes Cmd 00h (Stop All Activities) (Same as on 1841.0004/0018), IX++
        movi    gb,8000h			; Restore GB = 8000h, Point to Board Ports
        jbt     [gb].10h,4,Diagnextstep2	; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        movbi   bc,32h				; ECC DIAGNOSTIC ERROR !!! ECC Polynominal Error: During the controller's internal diagnostic tests, the hardware ECC generator failed its test.
        jmp     Error_Detected			; Done with Error

Diagnextstep2:  
	movbi   [gb].10h,0bbh			; Bit3 = 1 => Normal Opn ++ . D0=~VZ2/Xebec RD,D1=~VZ2/Xebec WR,D2=~VZ2/Xebec ECC,D3=Normal/VZ2/Xebec Opn,D4=Enable VZ2/Xebec Manage R/W Control,D6=Enable VZ2/Xebec End1,D7=D6=Enable VZ2/Xebec End2 (Internal Signals) (CHIP E08)
        movi    ga,ECC_Reference		; Offset ECC_Reference for Compare
        movbi   gb,60h				; Offset Temporary Byte
        movi    cc,0208h			; Set Transfer Block of BC Bytes, Lock, from [GA].Port to [GB].Port. ChannelControlRegister= 00 0 00 0 1 0 0 00 01 000
        wid     8,8				; 8-Bit Port to 8-Bit Port
        movbi   bc,1h				; Only One Byte
        xfer    				; Do Transfer On Next Command
        movbi   [gc+ix],80h			; VZ2/Xebec Serdes Base + 1 (Port1 4001h) = 80h ???
        movi    gb,8000h			; Restore GB = 8000h, Point to Board Ports
        jnbt    [gb].10h,4,Diagnextstep3	; VZ2/Xebec Error Pin17. D0=~TRACK0,D1=~WRFAULT,D2=~SEEKCOMP,D3=~READY,D6=Index (Signals from HDD),D4=Err From VZ2/Xebec, D7=~DIAGNOSTIC (CHIPS B06,B07)
        jmp     Error_Detected			; Done with Error

Diagnextstep3:  
	movb    mc,[gc+ix]			; MC = VZ2/Xebec Serdes (Port1 4001h) Value (Bits [2-0] !=0 When ECC Error)
        andbi   mc,7h				; MC &= 07h
        jnz     mc,Error_Detected		; If No Zero => Error_Detected
        movbi   gb,60h				; Offset Temporary Byte
        dec     ix				; IX = 4000h
        movbi   [gc+ix],2h			; VZ2/Xebec Serdes Cmd 02h (Compare Reference ECC) (Same as on 1841.0004/0018)
        movbi   [gc].61h,4h			; ECC Bytes Counter = 4

DiagEccTestLoop:  
	notb    mc,[gc+ix]			; MC = NOT VZ2/Xebec Serdes Port0 (4x ECC)
        addb    mc,[ga]				; Offset ECC_Reference
        inc     mc				; MC ++
        jnz     mc,Diag_Error			; If No Zero => Diag_Error
        xfer    				; Transfer on Next Command
        movbi   bc,8h				; Transfer 8 Bytes from [GA].Port to [GB].Port Without Inc Pointers - 8x the same byte, possible additional DMA check
        inc     ga				; GA ++ (Offset ECC_Reference ++)
        decb    [gc].61h			; Decrement ECC Bytes Counter
        jnzb    [gc].61h,DiagEccTestLoop	; Until No Zero => DiagEccTestLoop
        ljmp    FinishProcessToHostOK		; Done

Diag_Error:  
	movbi   bc,32h				; ECC DIAGNOSTIC ERROR !!! ECC Polynominal Error: During the controller's internal diagnostic tests, the hardware ECC generator failed its test.
        ljmp    ErrorDetected			; Done with Error

;==========================================
Cmd_ChkDrvReady:	;GA=4,GB=8000h,GC=0	; Cmd 00 (Test Drive Ready)
	lcall   [gc].4h,CheckDrvReady		; Check Drive Ready
        ljmp    FinishProcessToHostOK		; Done

;==========================================
DoDifficultSeekOpn:  				; Perform Difficult Seek Operation
	mov     ix,[gc].5ah			; IX = TemporaryWord. IX = WORD([gc].5ah, [gc].5bh)	
        movb    [gb].38h,[gc].4fh		; Set New Board Port 38 Value from it RAM Copy. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
        movi    mc,0606h			; Mask = 0606h
        jmcne   [gc].43h,SeekStep_No_3mS	; (((Control Byte from Host ^ 06) & 06) != 0) ? => SeekStep_No_3mS		;No 110, No 111

SeekStep_3mS:  					; Default step option : 3mS
	movi    bc,17bh				; BC = Counter for Step Option 3mS

SeekStep_70_or_200mkS:  
	ljmp    DoStepPulsAndChkDone		; Do Step Pulse And Check if All Done

SeekStep_No_3mS:  
	movi    mc,0700h			; Mask = 0700h
        jmce    [gc].43h,SeekStep_3mS		; (((Control Byte from Host ^ 00) & 07) == 0) ? => SeekStep_3mS			;000

        movbi   bc,12h				; BC = Counter for Step Option 200mkS
        orbi    mc,4h				; Mask = 0704h
        jmce    [gc].43h,SeekStep_70_or_200mkS	; (((Control Byte from Host ^ 04) & 07) == 0) ? => SeekStep_70_or_200mkS	;100

        movbi   bc,1h				; BC = Counter for Step Option 70mkS
        orbi    mc,1h				; Mask = 0705h
        jmce    [gc].43h,SeekStep_70_or_200mkS	; (((Control Byte from Host ^ 05) & 07) == 0) ? => SeekStep_70_or_200mkS	;101

        add     ix,[gc].5ah			; IX += TemporaryWord. IX = TemporaryWord * 2
        mov     [gc].5ah,ix			; TemporaryWord *= 2. WORD([gc].5ah, [gc].5bh) = IX	

        movi    bc,0bah				; BC = Counter for Step Option 60mkS (WD1002S-WX2 - OEM Manual.pdf)
        movi    mc,0702h			; Mask = 0702h
        ljmce   [gc].43h,SeekStep_60mkS		; (((Control Byte from Host ^ 02) & 07) == 0) ? => SeekStep_60mkS		;010

        addbi   ix,-4				; IX += 0FCh (-4)
        jnzb    [gc].5bh,SeekStep_XXmkS		; (HiByte TemporaryWord != 0) ? => SeekStep_XXmkS
        movi    mc,0ff02h			; Mask = FF02h
        ljmce   [gc].5ah,SeekStep_YYmkS		; ((TemporaryWord ^ 02h) & 0FFh == 0) ? => SeekStep_YYmkS

        movi    mc,0ff04h			; Mask = FF04h
        jmce    [gc].5ah,SeekStep_ZZmkS		; ((TemporaryWord ^ 04h) & 0FFh == 0) ? => SeekStep_ZZmkS

        addbi   [gc].5ah,-17			; BYTE TemporaryWord -= 17
        jnbt    [gc].5ah,7,SeekStep_XXmkS	; (TemporaryWord Bit7 == 0) ? => SeekStep_XXmkS

SeekStepLoop1:  
	movi    bc,12fh				; BC = StepPulse Width
        lcall   [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        movbi   bc,2ch				; BC = StepPulse Width
        lcall   [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        jnz     ix,SeekStepLoop1		; Loop until IX != 0
        jmp     SeekStep_ZZmkS			; Do SeekStep_ZZmkS

SeekStep_XXmkS:  
	addbi   ix,-4				; IX += FCh (-4)
        movi    bc,87h				; BC = StepPulse Width
        lcall   [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        movbi   bc,20h				; BC = StepPulse Width
        lcall   [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        call    [gc],DoOneStepPulseWide57h	; Do One Step Pulse 57h Width
        call    [gc],DoOneStepPulseWideE5h	; Do One Step Pulse E5h Width
        movbi   bc,60h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        call    [gc],DoOneStepPulseWide3Dh	; Do One Step Pulse 3Dh Width

SeekStepLoop2:  
	movbi   bc,46h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        jnz     ix,SeekStepLoop2		; Loop until IX != 0

        movi    bc,0bah				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        movbi   bc,7ah				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        call    [gc],DoOneStepPulseWide3Dh	; Do One Step Pulse 3Dh Width
        call    [gc],DoOneStepPulseWide57h	; Do One Step Pulse 57h Width

SeekStep_ZZmkS:  
	call    [gc],DoOneStepPulseWide98h	; Do One Step Pulse 98h Width
        call    [gc],DoOneStepPulseWide2Fh	; Do One Step Pulse 2Fh Width
        movbi   bc,2dh				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWide20h	; Do One Step Pulse 20h Width
        call    [gc],DoOneStepPulseWide98h	; Do One Step Pulse 98h Width
        call    [gc],DoOneStepPulseWide2Fh	; Do One Step Pulse 2Fh Width
        movbi   bc,39h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWide20h	; Do One Step Pulse 20h Width
        call    [gc],DoOneStepPulseWideE5h	; Do One Step Pulse E5h Width
        ljmp    DoOneStepPulseWide02h		; Do One Step Pulse 02h Width

DoOneStepPulseWide20h:  
	movb    mc,[gc].4fh			; MC = Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR
        addbi   mc,20h				; Activate ~DIR Signal (Inverted)
        jmp     DoOneStepPulseWideAsBC_InitByMC	; Do One Step Pulse, BC = Width, MC = Initial Board Port 39h Value

DoOneStepPulseWideE5h:  
	movi    bc,0e1h				; BC = StepPulse Width
        jmp     DoOneStepPulseWideAsBC		; Do One Step Pulse, BC = Width

DoOneStepPulseWide98h:  
	movi    bc,94h				; BC = StepPulse Width
        jmp     DoOneStepPulseWideAsBC		; Do One Step Pulse, BC = Width

DoOneStepPulseWide57h:  
	movbi   bc,53h				; BC = StepPulse Width
        jmp     DoOneStepPulseWideAsBC		; Do One Step Pulse, BC = Width

DoOneStepPulseWide3Dh:  
	movbi   bc,39h				; BC = StepPulse Width
        jmp     DoOneStepPulseWideAsBC		; Do One Step Pulse, BC = Width

DoOneStepPulseWide2Fh:  
	movbi   bc,2dh				; BC = StepPulse Width

;==========================================
DoOneStepPulseWideAsBC:				; Do One Step Pulse, BC = Width
	movb    mc,[gc].4fh			; MC = Board Port 39 Value (Chip H14) = ~HDx/~Step/~Dir/~REDWRCUR

DoOneStepPulseWideAsBC_InitByMC:		; Do One Step Pulse, BC = Width, MC = Initial Board Port 39h Value
        movb    [gb].39h,mc			; Set New Board Port 39 (Same as 38) Value from MC. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
        orbi    mc,10h				; Activate ~STEP Signal (Inverted)
        movb    [gb].38h,mc			; Set New Board Port 38 Value from MC. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)
        dec     ix				; Decrement IX
        mov     [gc].5ah,ix			; TemporaryWord = IX. WORD([gc].5ah, [gc].5bh) = IX
        andbi   mc,0afh				; MC &= AFh
        movb    [gb].38h,mc			; Set New Board Port 38 Value from MC. D0=~HDSEL0,D1=~HDSEL1,D2=~HDSEL2,D4=~STEP,D5=~DIR,D7=~REDWRCUR (Signals to HDD)	; Both Address 38/39 are valid (CHIP B08)

StepWaitLoop:  
	dec     bc				; Decrement Width Counter
        ljnz    bc,StepWaitLoop			; Loop Until Width Counter != 0
        mov     tp,[gc]				; Return

;==========================================
SeekStep_YYmkS:  
	movi    bc,162h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        jmp     DoOneStepPulseWide02h		; Do One Step Pulse 02h Width

SeekStep_60mkS:  
	jnzb    [gc].5bh,SeekStepContinue	; (HiByte TemporaryWord != 0) ? => SeekStepContinue
        addbi   [gc].5ah,-16			; BYTE TemporaryWord -= 16
        jbt     [gc].5ah,7,DoStepPulsAndChkDone	; (TemporaryWord Bit7 == 1) ? => DoStepPulsAndChkDone

SeekStepContinue:  
	addbi   ix,-4				; IX += FCh (-4)
        movbi   [gc].60h,4h			; SeekCnt = 4

SeekStepLoop6:  
	movi    bc,0bah				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        decb    [gc].60h			; Decrement SeekCnt
        jnzb    [gc].60h,SeekStepLoop6		; Loop While SeekCnt != 0
        movbi   [gc].60h,4h			; SeekCnt = 4

SeekStepLoop7:  
	movbi   bc,79h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        decb    [gc].60h			; Decrement SeekCnt
        jnzb    [gc].60h,SeekStepLoop7		; Loop While SeekCnt != 0

SeekStepLoop5:  
	movbi   bc,59h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        jnz     ix,SeekStepLoop5

        movi    bc,13bh				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        movi    bc,0fbh				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        call    [gc],DoOneStepPulseWide2Fh	; Do One Step Pulse 2Fh Width

DoOneStepPulseWide02h:  
	movi    bc,1h				; BC = StepPulse Width
        call    [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width

SeekChkAllComplete:  
	movi    mc,0ff0bh			; Mask = FF0Bh
        jmcne   [gc].3eh,Cmd_Not_Seek		; if((HostCmd ^ 0Bh) & FFh) != 0 => Cmd_Not_Seek. [gc].3eh
        movi    mc,0604h			; Mask = 0604h
        jmce    [gc].43h,DriveAlreadyChecked	; if((Control Byte from Host ^ 04h) && 06h) == 0 => DriveAlreadyChecked

Cmd_Not_Seek:  
	lcall   [gc],WaitReadyAndSeekComplete	; Wait Ready And Seek Complete. If Timeout => ErrorDetected
        mov     tp,[gc].4h			; Return

DoStepPulsAndChkDone:  
	mov     [gc].5ch,bc			; Save BC. TemporaryBC = BC. WORD([gc].5ch, [gc].5dh) = BC	
        lcall   [gc],DoOneStepPulseWideAsBC	; Do One Step Pulse, BC = Width
        mov     bc,[gc].5ch			; restore BC. BC = TemporaryBC. BC = WORD([gc].5ch, [gc].5dh)	
        jnz     ix,DoStepPulsAndChkDone		; Loop until IX != 0
        jmp     SeekChkAllComplete		; Check if All Complete

DriveAlreadyChecked:  				; Set DriveCheckedAndReady Bitmask for this Drive
	movb    mc,[gc].4ch			; MC = Port 18h Saved Value. Cur Drive. SELECT/NO DIAG/OUT/DATA. D0=DRIVESEL1 (Signal to HDD),D3=Select,D4=~DIAGNOSTIC,D5=IN/~OUT,D6=C/~D,D7=SETINTR (Internal Signals) (CHIP B09)
        orb     [gc].3ah,mc			; Set DriveCheckedAndReady Bitmask for this Drive
        ljmp    FinishProcessToHostOK		; Done

;==========================================

	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment (Offset FEC3h)
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; 16x 0h Reserved / Alignment

;==========================================
HostCmdTable:
	dw      Cmd_ChkDrvReady			; 00 (Test Drive Ready)
	dw	Cmd_DrvRecalibrate		; 01 (Recalibrate)
	dw	Cmd_Unknown			; 02 (Reserved)
	dw	Cmd_RequestSense		; 03 (Request Sense Status)
	dw	Cmd_Format			; 04 (Format Drive)
	dw	Cmd_Read_Verify			; 05 (Ready Verify)
	dw	Cmd_Format			; 06 (Format Track)
	dw	Cmd_Format			; 07 (Format Bad Track)
	dw	Cmd_Read_Verify			; 08 (Read)
	dw	Cmd_Unknown			; 09 (Reserved)
        dw	Cmd_Write			; 0A (Write)
        dw	Cmd_Seek			; 0B (Seek)
        dw	Cmd_InitDrive			; 0C (Initialize Drive Characteristics)
        dw	Cmd_ReadEccBurst		; 0D (Read ECC Burst Error Length)
        dw	Cmd_ReadSectBuf			; 0E (Read Data from Sector Buffer)
        dw	Cmd_WriteSectBuf		; 0F (Write Data to Sector Buffer)

	; Class 7 Host Cmds

        dw      Cmd_RamDiag			; E0 (RAM Diagnostic)
	dw	Cmd_Unknown			; E1 (Reserved)
	dw	Cmd_Unknown			; E2 (Reserved)
        dw	Cmd_DriveDiag			; E3 (Drive Diagnostic)
        dw	Cmd_CtrlrDiag			; E4 (Controller Internal Diagnostics)
	dw	Cmd_Read_Verify			; E5 (Read Long)
        dw	Cmd_Write			; E6 (Write Long)
        dw	Cmd_Undoc1			; E7 (Undocumented1, ES-1842 Specific)
        dw	Cmd_Undoc2			; E8 (Undocumented2, ES-1842 Specific)

;==========================================
ECC_Reference:
        db      5h, 0h, 40h, 28h		; ECC_Reference for Compare

;==========================================
RelocToRamArea:
        db      60h				; TimeOut After AM NoLastSector	; 9 bytes Moved From ROM RelocToRamArea Start <=;
        db      69h				; Timeout1 For Format Operation							;        
        db      0h 				; Not Used									;
        db      54h				; Timeout After AM ID Readed							;
        db      54h				; Timeout After Last Sector AM ID Readed					;
        db      8h 				; SectNum when FmtNotWaitIndex							;
        db      11h				; Sectors Per Track (17)							;
        db	60h, 00h			; Timeout2 For Format Operation	; 9 bytes Moved From ROM RelocToRamArea End <===;

;==========================================
; FFD2h
HddParTable:					; Represent as Bytes, not Words !
        db      01h,	32h			; Cyl		306	; 132h
        db      4 				; Head			; 4h
        db      01h,	32h			; RWC Cyl	306	; 132h
        db      0h,	0h			; WP Cyl		; 0h
        db      11				; EEC Burst Len		; 0bh

;==========================================
; FFDA: 
Chan1Start:					;					^^^
	dw      Chan1_Start			; DW F000 : CHAN1 PROGRAM START SEG (Chan1_Start) <......
        dw      0h				; DW 0000 : CHAN1 PROGRAM START OFF			;
; FFDEh													;
CB:													;
        dw      0001h		;..> Ch1 (CB+0)	; DW 0001 : NotBusy, IoSpace, NoInt			;
	dw	Chan1Start	;		; DW FFDA : PB1 SEG >....................................
        dw      0h		;		; DW 0000 : PB1 OFF
        dw      0h		;		; DW 0000 : RESERVED
        dw      0001h		;    Ch2 (CB+8)	; DW 0001 : NotBusy, IoSpace, NoInt
	dw	Chan2Start	;		; DW FFEC : PB2 SEG >....................................
        dw      0h		;		; DW 0000 : PB2 OFF					;
; FFEC				;									;
Chan2Start:			;		;					^^^		;
        dw      Chan2_Start	;		; DW F9E3 : CHAN2 PROGRAM START SEG (Chan2_Start) <......
        dw      0h		;		; DW 0000 : CHAN2 PROGRAM START OFF
				;
; FFF0h				;
SCB:				;
        dw	0000h		;		; DW 0000 : SOC=8bit I/O,Stand.mode <....     
        dw      CB		;.............<	; DW FFDE : CB PTR SEG			;
        dw	0h     				; DW 0000 : CB PTR OFF			;
											;
; FFF6h	=> FIXED ADDRESS, ALL START HERE, VIZ DATASHEET !!!				;
SCPB:											;
        dw	0000h				; DW 0000 : SYSBUS = 8 Bit		;     
        dw      SCB				; DW FFF0 : SCB PTR SEG >................
        dw	0h     				; DW 0000 : SCB PTR OFF 
        dw	0h     				; DW 0000 : UNUSED
        dw	5c66h				; DW 5C66 : ROM CRC COMPLEMENT VALUE FOR ZERO CRC COMPARE (See [pp].24h)
